
#include "config.h"
#include "debug.h"
#include "config.h"
#include "res.h"
#include "rescommon.h"

#pragma code_page(28591)

#define FILE_DESCRIPTION  "Vice C64DTV Emulator"



IDR_MENUC64DTV MENU DISCARDABLE
BEGIN
    POPUP N_("&File")
    BEGIN
        MENUITEM "", IDM_AUTOSTART
        MENUITEM SEPARATOR
        POPUP N_("Attach &disk image")
        BEGIN
            MENUITEM "", IDM_ATTACH_8
            MENUITEM "", IDM_ATTACH_9
            MENUITEM "", IDM_ATTACH_10
            MENUITEM "", IDM_ATTACH_11
        END
        POPUP N_("D&etach disk image")
        BEGIN
            MENUITEM "", IDM_DETACH_8
            MENUITEM "", IDM_DETACH_9
            MENUITEM "", IDM_DETACH_10
            MENUITEM "", IDM_DETACH_11
            MENUITEM SEPARATOR
            MENUITEM "", IDM_DETACH_ALL
        END
        POPUP N_("DTV flash &rom image")
        BEGIN
            MENUITEM "", IDM_ATTACH_DTV_FLASH
            MENUITEM "", IDM_DETACH_DTV_FLASH
            MENUITEM "", IDM_CREATE_DTV_FLASH
        END
        POPUP N_("&Flip list")
        BEGIN
            MENUITEM "", IDM_FLIP_ADD
            MENUITEM "", IDM_FLIP_REMOVE
            MENUITEM "", IDM_FLIP_NEXT
            MENUITEM "", IDM_FLIP_PREVIOUS
            MENUITEM SEPARATOR
            MENUITEM "", IDM_FLIP_LOAD
            MENUITEM "", IDM_FLIP_SAVE
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_PAUSE, CHECKED
        MENUITEM "", IDM_MONITOR
        POPUP N_("&Reset")
        BEGIN
            MENUITEM "", IDM_RESET_HARD
            MENUITEM "", IDM_RESET_SOFT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_RESET_DRIVE8
            MENUITEM "", IDM_RESET_DRIVE9
            MENUITEM "", IDM_RESET_DRIVE10
            MENUITEM "", IDM_RESET_DRIVE11
        END
#ifdef DEBUG
        POPUP N_("&Debug")
        BEGIN
            POPUP N_("M&ode")
            BEGIN
                MENUITEM "", IDM_DEBUG_MODE_NORMAL
                MENUITEM "", IDM_DEBUG_MODE_SMALL
                MENUITEM "", IDM_DEBUG_MODE_HISTORY
                MENUITEM "", IDM_DEBUG_MODE_AUTOPLAY
            END
            MENUITEM "", IDM_TOGGLE_MAINCPU_TRACE,   CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE0CPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE1CPU_TRACE, CHECKED
        END
#endif
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EXIT
    END
    POPUP N_("Edit")
    BEGIN
        MENUITEM "", IDM_EDIT_COPY
        MENUITEM "", IDM_EDIT_PASTE
    END
    POPUP N_("Sna&pshot")
    BEGIN
        MENUITEM "", IDM_SNAPSHOT_LOAD
        MENUITEM "", IDM_SNAPSHOT_SAVE
        MENUITEM "", IDM_LOADQUICK
        MENUITEM "", IDM_SAVEQUICK
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EVENT_TOGGLE_RECORD
        MENUITEM "", IDM_EVENT_TOGGLE_PLAYBACK
        MENUITEM "", IDM_EVENT_SETMILESTONE
        MENUITEM "", IDM_EVENT_RESETMILESTONE
        POPUP N_("Recording start mode")
        BEGIN
            MENUITEM "", IDM_EVENT_START_MODE_SAVE
            MENUITEM "", IDM_EVENT_START_MODE_LOAD
            MENUITEM "", IDM_EVENT_START_MODE_RESET
            MENUITEM "", IDM_EVENT_START_MODE_PLAYBACK
        END
        MENUITEM "", IDM_EVENT_DIRECTORY
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MEDIAFILE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SOUND_RECORD_START
        MENUITEM "", IDM_SOUND_RECORD_STOP
    END
    POPUP N_("&Options")
    BEGIN
        POPUP N_("&Refresh rate")
        BEGIN
            MENUITEM "",      IDM_REFRESH_RATE_AUTO
            MENUITEM N_("1/&1"),  IDM_REFRESH_RATE_1
            MENUITEM N_("1/&2"),  IDM_REFRESH_RATE_2
            MENUITEM N_("1/&3"),  IDM_REFRESH_RATE_3
            MENUITEM N_("1/&4"),  IDM_REFRESH_RATE_4
            MENUITEM N_("1/&5"),  IDM_REFRESH_RATE_5
            MENUITEM N_("1/&6"),  IDM_REFRESH_RATE_6
            MENUITEM N_("1/&7"),  IDM_REFRESH_RATE_7
            MENUITEM N_("1/&8"),  IDM_REFRESH_RATE_8
            MENUITEM N_("1/&9"),  IDM_REFRESH_RATE_9
            MENUITEM N_("1/1&0"), IDM_REFRESH_RATE_10
        END
        POPUP N_("&Maximum Speed")
        BEGIN
            MENUITEM N_("&200%"), IDM_MAXIMUM_SPEED_200
            MENUITEM N_("&100%"), IDM_MAXIMUM_SPEED_100
            MENUITEM N_("&50%"),  IDM_MAXIMUM_SPEED_50
            MENUITEM N_("&20%"),  IDM_MAXIMUM_SPEED_20
            MENUITEM N_("1&0%"),  IDM_MAXIMUM_SPEED_10
            MENUITEM "",      IDM_MAXIMUM_SPEED_NO_LIMIT
            MENUITEM SEPARATOR
            MENUITEM "",      IDM_MAXIMUM_SPEED_CUSTOM
        END
        MENUITEM "", IDM_TOGGLE_WARP_MODE,             CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_FULLSCREEN
        MENUITEM "", IDM_TOGGLE_ALWAYSONTOP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_VIDEOCACHE,            CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESIZE,            CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESCAN,            CHECKED
        MENUITEM "", IDM_TOGGLE_FASTPAL,               CHECKED
        MENUITEM "", IDM_TOGGLE_SCALE2X,               CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SWAP_JOYSTICK
        MENUITEM "", IDM_SWAP_EXTRA_JOYSTICK
        MENUITEM "", IDM_ALLOW_JOY_OPPOSITE_TOGGLE
        MENUITEM "", IDM_JOYKEYS_TOGGLE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SOUND,                 CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_DRIVE_TRUE_EMULATION,  CHECKED
        MENUITEM "", IDM_TOGGLE_AUTOSTART_HANDLE_TDE
        MENUITEM "", IDM_TOGGLE_FLASH_TRUE_FILESYSTEM, CHECKED
        MENUITEM "", IDM_TOGGLE_VIRTUAL_DEVICES
        MENUITEM SEPARATOR
        POPUP N_("Vide&o standard")
        BEGIN
            MENUITEM N_("&PAL-G"),      IDM_SYNC_FACTOR_PAL
            MENUITEM N_("&NTSC-M"),     IDM_SYNC_FACTOR_NTSC
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_PS2MOUSE
        MENUITEM "", IDM_MOUSE
    END
    POPUP N_("S&ettings")
    BEGIN
        MENUITEM "", IDM_AUTOSTART_SETTINGS
        MENUITEM "", IDM_VIDEO_SETTINGS
        MENUITEM "", IDM_DEVICEMANAGER
        MENUITEM "", IDM_DRIVE_SETTINGS
        MENUITEM "", IDM_VICII_SETTINGS
        MENUITEM "", IDM_JOY_SETTINGS
        MENUITEM "", IDM_EXTRA_JOY_SETTINGS
        MENUITEM "", IDM_KEYBOARD_SETTINGS
        MENUITEM "", IDM_SOUND_SETTINGS
        MENUITEM "", IDM_SID_SETTINGS
        MENUITEM "", IDM_ROM_SETTINGS
        MENUITEM "", IDM_RAM_SETTINGS
        MENUITEM "", IDM_C64DTV_SETTINGS
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SETTINGS_SAVE_FILE
        MENUITEM "", IDM_SETTINGS_LOAD_FILE
        MENUITEM "", IDM_SETTINGS_SAVE
        MENUITEM "", IDM_SETTINGS_LOAD
        MENUITEM "", IDM_SETTINGS_DEFAULT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SAVE_SETTINGS_ON_EXIT
        MENUITEM "", IDM_TOGGLE_CONFIRM_ON_EXIT
    END
    POPUP N_("&Language")
    BEGIN
        MENUITEM "", IDM_LANG_EN
        MENUITEM "", IDM_LANG_DA
        MENUITEM "", IDM_LANG_DE
        MENUITEM "", IDM_LANG_FR
        MENUITEM "", IDM_LANG_HU
        MENUITEM "", IDM_LANG_IT
        MENUITEM "", IDM_LANG_NL
        MENUITEM "", IDM_LANG_PL
        MENUITEM "", IDM_LANG_SV
        MENUITEM "", IDM_LANG_TR
    END
    POPUP N_("&Help")
    BEGIN
        MENUITEM "", IDM_HELP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ABOUT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CMDLINE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CONTRIBUTORS
        MENUITEM "", IDM_LICENSE
        MENUITEM "", IDM_WARRANTY
    END
END



IDD_C64ROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 70
BEGIN
    LTEXT      "", IDC_KERNAL,
               9, 8, 40, 8
    EDITTEXT   IDC_C64ROM_KERNAL_FILE,
               55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C64ROM_KERNAL_BROWSE,
               185, 7, 50, 14, 0

    LTEXT      "", IDC_BASIC,
               9, 28, 40, 8
    EDITTEXT   IDC_C64ROM_BASIC_FILE,
               55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C64ROM_BASIC_BROWSE,
               185, 27, 50, 14, 0

    LTEXT      "", IDC_CHARACTER,
               9, 48, 40, 8
    EDITTEXT   IDC_C64ROM_CHARGEN_FILE,
               55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C64ROM_CHARGEN_BROWSE,
               185, 47, 50, 14, 0
END



IDD_C64DRIVEROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 210
BEGIN
    LTEXT      N_("1541"), IDC_1541,
               9, 8, 40, 8
    EDITTEXT   IDC_DRIVEROM_1541_FILE,
               55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1541_BROWSE,
               185, 7, 50, 14, 0

    LTEXT      N_("1541-II"), IDC_1541_II,
               9, 28, 40, 8
    EDITTEXT   IDC_DRIVEROM_1541II_FILE,
               55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1541II_BROWSE,
               185, 27, 50, 14, 0

    LTEXT      N_("1570"), IDC_1570,
               9, 48, 40, 8
    EDITTEXT   IDC_DRIVEROM_1570_FILE,
               55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1570_BROWSE,
               185, 47, 50, 14, 0

    LTEXT      N_("1571"), IDC_1571,
               9, 68, 40, 8
    EDITTEXT   IDC_DRIVEROM_1571_FILE,
               55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1571_BROWSE,
               185, 67, 50, 14, 0

    LTEXT      N_("1581"), IDC_1581,
               9, 88, 40, 8
    EDITTEXT   IDC_DRIVEROM_1581_FILE,
               55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1581_BROWSE,
               185, 87, 50, 14, 0
END



IDD_C64ROM_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 85
BEGIN
    GROUPBOX      "", IDC_COMPUTER_RESOURCES,
                  4, 3, 151, 55
    AUTOCHECKBOX  "", IDC_C64ROM_KERNAL_RESOURCE,
                  11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C64ROM_BASIC_RESOURCE,
                  11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C64ROM_CHARGEN_RESOURCE,
                  11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  20, 65, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  80, 65, 50, 14, WS_TABSTOP
END



IDD_C64ROMDRIVE_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 190
BEGIN
    GROUPBOX      "", IDC_DRIVE_RESOURCES,
                  4, 3, 151, 160
    AUTOCHECKBOX  N_("1541"), IDC_DRIVEROM_1541_RESOURCE,
                  11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1541-II"), IDC_DRIVEROM_1541II_RESOURCE,
                  11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1570"), IDC_DRIVEROM_1570_RESOURCE,
                  11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1571"), IDC_DRIVEROM_1571_RESOURCE,
                  11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1581"), IDC_DRIVEROM_1581_RESOURCE,
                  11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  20, 170, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  80, 170, 50, 14, WS_TABSTOP
END



IDD_C64KBD_MAPPING_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 140
BEGIN
    AUTORADIOBUTTON "", IDC_C64KBD_MAPPING_SELECT_SYM,
                    10, 10, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_C64KBD_MAPPING_SELECT_SYMDE,
                    10, 30, 54, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_C64KBD_MAPPING_SELECT_POS,
                    10, 50, 54, 10, BS_AUTORADIOBUTTON

    EDITTEXT        IDC_C64KBD_MAPPING_SYM,
                    65, 9, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C64KBD_MAPPING_SYM_BROWSE,
                    185, 9, 50, 14, 0
    EDITTEXT        IDC_C64KBD_MAPPING_SYMDE,
                    65, 29, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C64KBD_MAPPING_SYMDE_BROWSE,
                    185, 29, 50, 14, 0
    EDITTEXT        IDC_C64KBD_MAPPING_POS,
                    65, 49, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C64KBD_MAPPING_POS_BROWSE,
                    185, 49, 50, 14, 0

    PUSHBUTTON      "", IDC_C64KBD_MAPPING_DUMP,
                    10, 74, 60, 14, 0
    PUSHBUTTON      "", IDC_KBD_SHORTCUT_DUMP,
                    80, 74, 60, 14, 0

    DEFPUSHBUTTON   "", IDOK,
                    20, 120, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 120, 50, 14, WS_TABSTOP
END



IDD_C64DTV_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 180, 110
BEGIN
    LTEXT         "", IDC_DTV_REVISION_LABEL,
                  63, 6, 110, 8
    COMBOBOX      IDC_DTV_REVISION,
                  9, 5, 50, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_ENABLE_HUMMER_ADC,
                  11, 32, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  30, 84, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  90, 84, 50, 14, WS_TABSTOP
END



IDD_C64DTV_ATTACH_FLASH_IMAGE_DIALOG DIALOG DISCARDABLE 0, 0, 180, 100
BEGIN
    GROUPBOX      N_("DTV ROM"), IDC_DTV_ROM,
                  3, 2, 174, 55
    LTEXT         "", IDC_C64DTV_ROM_IMAGE_FILE_LABEL,
                  9, 14, 100, 8
    PUSHBUTTON    "", IDC_C64DTV_ROM_IMAGE_BROWSE,
                  123, 10, 50, 14, 0
    EDITTEXT      IDC_C64DTV_ROM_IMAGE_FILE,
                  9, 26, 164, 12, WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C64DTV_ROM_WRITE_ENABLE,
                  7, 41, 120, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    DEFPUSHBUTTON "", IDOK,
                  30, 74, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  90, 74, 50, 14, WS_TABSTOP
END



IDD_C64DTV_CREATE_FLASH_IMAGE_DIALOG DIALOG DISCARDABLE 0, 0, 180, 100
BEGIN
    GROUPBOX        "", IDC_DTV_ROM_CREATION,
                    3, 2, 174, 55
    LTEXT           "", IDC_C64DTV_ROM_IMAGE_FILE_LABEL,
                    9, 14, 100, 8
    PUSHBUTTON      "", IDC_C64DTV_ROM_IMAGE_BROWSE,
                    123, 10, 50, 14, 0
    EDITTEXT        IDC_C64DTV_ROM_IMAGE_FILE,
                    9, 26, 164, 12, WS_TABSTOP
    AUTOCHECKBOX    "", IDC_C64DTV_ROM_COPY_C64,
                    7, 41, 120, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    DEFPUSHBUTTON   "", IDOK,
                    30, 74, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    90, 74, 50, 14, WS_TABSTOP
END



STRINGTABLE
BEGIN
  IDS_ATTACH_FLASH_CAPTION        N_("Attach DTV Flash Image")
  IDS_DTV_ROM                     N_("DTV ROM")
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL N_("DTV ROM &image File")
  IDS_C64DTV_ROM_WRITE_ENABLE     N_("Enable &writes to DTV ROM image")
  IDS_C64DTV_SETTINGS_CAPTION     N_("C64DTV Settings")
  IDS_DTV_REVISION_LABEL          N_("DTV Revision")
  IDS_ENABLE_HUMMER_ADC           N_("Enable Hummer ADC")
  IDS_CREATE_FLASH_CAPTION        N_("Create DTV Flash Image")
  IDS_DTV_ROM_CREATION            N_("DTV ROM Creation")
  IDS_C64DTV_ROM_COPY_C64         N_("Copy C64 ROMS into image")
  IDS_CREATE                      N_("Create")
  IDS_MP_DTV_FLASH_ROM_IMAGE      N_("DTV flash &rom image")
  IDS_MI_AUTOSTART_DISK           N_("&Autostart disk image...")
  IDS_MI_ATTACH_DTV_FLASH         N_("Attach &flash rom image")
  IDS_MI_DETACH_DTV_FLASH         N_("&Detach flash rom image")
  IDS_MI_CREATE_DTV_FLASH         N_("&Create new flash rom image")
  IDS_MI_FLASH_TRUE_FILESYSTEM    N_("&True flash filesystem")
  IDS_MI_PS2MOUSE                 N_("&PS/2 mouse emulation")
  IDS_MI_C64DTV_SETTINGS          N_("&C64DTV settings...")
  IDS_JOYSTICK                    N_("Joystick")
END



STRINGTABLE
LANGUAGE LANG_DANISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "Tilslut DTV-flashimage"
  IDS_DTV_ROM                     "DTV-ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM-&imagefil"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Aktivr &skrivning til DTV-ROM-image"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV-indstillinger"
  IDS_DTV_REVISION_LABEL          "DTV-revision"
  IDS_ENABLE_HUMMER_ADC           "Enable Hummer ADC"
  IDS_CREATE_FLASH_CAPTION        "Opret DTV-flashimage"
  IDS_DTV_ROM_CREATION            "DTV-ROM oprettelse"
  IDS_C64DTV_ROM_COPY_C64         "Kopir C64-ROM'mer til image"
  IDS_CREATE                      "Opret"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV-flash&rom image"
  IDS_MI_AUTOSTART_DISK           "&Autostart disketteimage..."
  IDS_MI_ATTACH_DTV_FLASH         "Tilslut &flash-rom-image"
  IDS_MI_DETACH_DTV_FLASH         "Fra&kobl flash-rom-imagesfil"
  IDS_MI_CREATE_DTV_FLASH         "&Opret nyt flash-rom-image"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&gte flash-filsystem"
  IDS_MI_PS2MOUSE                 "Emulering af &PS/2-mus"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV-indstillinger..."
  IDS_JOYSTICK                    "Joystick"
END



STRINGTABLE
LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "DTV Flash Image einlegen"
  IDS_DTV_ROM                     "DTV ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM &Image Name"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Erlaube &Schreibzugriff auf DTV ROM Datei"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV Einstellungen"
  IDS_DTV_REVISION_LABEL          "DTV Revision"
  IDS_ENABLE_HUMMER_ADC           "Hummer ADC Aktivieren"
  IDS_CREATE_FLASH_CAPTION        "DTV Image Datei erzeugen"
  IDS_DTV_ROM_CREATION            "DTV ROM Erzeugung"
  IDS_C64DTV_ROM_COPY_C64         "C64 ROMS auf Image kopieren"
  IDS_CREATE                      "Erzeugen"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV Flash &Rom Datei"
  IDS_MI_AUTOSTART_DISK           "&Autostart Disk Image..."
  IDS_MI_ATTACH_DTV_FLASH         "&Flash ROM Image einlegen"
  IDS_MI_DETACH_DTV_FLASH         "Flash ROM Image ent&fernen"
  IDS_MI_CREATE_DTV_FLASH         "Flash ROM Datei er&zeugen"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&True flash Dateisystem"
  IDS_MI_PS2MOUSE                 "&PS/2 Mausemulation"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV Einstellungen..."
  IDS_JOYSTICK                    "Joystick"
END



STRINGTABLE
LANGUAGE LANG_FRENCH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "Attach DTV Flash Image"
  IDS_DTV_ROM                     "DTV ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM &image File"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Enable &writes to DTV ROM image"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV Settings"
  IDS_DTV_REVISION_LABEL          "DTV Revision"
  IDS_ENABLE_HUMMER_ADC           "Enable Hummer ADC"
  IDS_CREATE_FLASH_CAPTION        "Create DTV Flash Image"
  IDS_DTV_ROM_CREATION            "DTV ROM Creation"
  IDS_C64DTV_ROM_COPY_C64         "Copy C64 ROMS into image"
  IDS_CREATE                      "Create"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV flash &rom image"
  IDS_MI_AUTOSTART_DISK           "Dmarrage &automatique d'une image lecteur..."
  IDS_MI_ATTACH_DTV_FLASH         "Attach &flash rom image"
  IDS_MI_DETACH_DTV_FLASH         "&Detach flash rom image"
  IDS_MI_CREATE_DTV_FLASH         "&Create new flash rom image"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&True flash filesystem"
  IDS_MI_PS2MOUSE                 "&PS/2 mouse emulation"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV settings..."
  IDS_JOYSTICK                    "Joystick"
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_HUNGARIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "DTV Flash kpms csatolsa"
  IDS_DTV_ROM                     "DTV ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM &kpms fjl"
  IDS_C64DTV_ROM_WRITE_ENABLE     "DTV ROM kpmsba rs &engedlyezse"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV belltsai"
  IDS_DTV_REVISION_LABEL          "DTV vltozat"
  IDS_ENABLE_HUMMER_ADC           "Enable Hummer ADC"
  IDS_CREATE_FLASH_CAPTION        "DTV Flash kpms ltrehozsa"
  IDS_DTV_ROM_CREATION            "DTV ROM ltrehozs"
  IDS_C64DTV_ROM_COPY_C64         "C64 ROM-ok msolsa a kpmsba"
  IDS_CREATE                      "Ltrehozs"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV flash &rom kpms"
  IDS_MI_AUTOSTART_DISK           "Lemezkpms &automatikus indtsa..."
  IDS_MI_ATTACH_DTV_FLASH         "&Flash ROM kpms csatolsa"
  IDS_MI_DETACH_DTV_FLASH         "Flash ROM kpms &levlasztsa"
  IDS_MI_CREATE_DTV_FLASH         "j flash rom kpms &ltrehozsa"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&Igazi flash fjlrendszer"
  IDS_MI_PS2MOUSE                 "&PS/2 egr emulci"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV belltsai..."
  IDS_JOYSTICK                    "Botkormny"
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_ITALIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "Seleziona l'immagine di una memoria flash DTV"
  IDS_DTV_ROM                     "ROM DTV"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "File &immagine ROM DTV"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Attiva &scrittura su immagini ROM DTV"
  IDS_C64DTV_SETTINGS_CAPTION     "Impostazioni C64DTV"
  IDS_DTV_REVISION_LABEL          "Revisione DTV"
  IDS_ENABLE_HUMMER_ADC           "Attiva Hummer ADC"
  IDS_CREATE_FLASH_CAPTION        "Crea l'immagine di una memoria flash DTV"
  IDS_DTV_ROM_CREATION            "Creazione ROM DTV"
  IDS_C64DTV_ROM_COPY_C64         "Copia ROM C64 in un'immagine"
  IDS_CREATE                      "Crea"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV flash &rom image"
  IDS_MI_AUTOSTART_DISK           "Avvia automaticamente l'immagine del disco"
  IDS_MI_ATTACH_DTV_FLASH         "Seleziona l'immagine di una rom &flash"
  IDS_MI_DETACH_DTV_FLASH         "&Rimuovi l'immagine di una rom flash"
  IDS_MI_CREATE_DTV_FLASH         "&Crea una nuova immagine di una rom flash"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "Attiva l'emulazione &hardware del filesystem flash"
  IDS_MI_PS2MOUSE                 "Emulazione del mouse &PS/2"
  IDS_MI_C64DTV_SETTINGS          "Impostazioni &C64DTV..."
  IDS_JOYSTICK                    "Joystick"
END



STRINGTABLE
LANGUAGE LANG_DUTCH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "Koppel DTV Flash Bestand"
  IDS_DTV_ROM                     "DTV ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM &bestand"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Aktiveer &schrijven naar DTV ROM bestand"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV Instellingen"
  IDS_DTV_REVISION_LABEL          "DTV Revisie"
  IDS_ENABLE_HUMMER_ADC           "Activeer Hummer ADC"
  IDS_CREATE_FLASH_CAPTION        "Maak DTV Flash Bestand"
  IDS_DTV_ROM_CREATION            "Maak DTV ROM"
  IDS_C64DTV_ROM_COPY_C64         "Kopieer C64 ROMS naar bestand"
  IDS_CREATE                      "Maak"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV flash &rom bestand"
  IDS_MI_AUTOSTART_DISK           "&Autostart diskbestand..."
  IDS_MI_ATTACH_DTV_FLASH         "Koppel &flash rom bestand"
  IDS_MI_DETACH_DTV_FLASH         "&Ontkoppel flash rom bestand"
  IDS_MI_CREATE_DTV_FLASH         "&Maak nieuw flash rom bestand"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&Hardwarematig flash bestandssysteem"
  IDS_MI_PS2MOUSE                 "&PS/2 muis emulatie"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV instellingen..."
  IDS_JOYSTICK                    "Joystick"
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_POLISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "Attach DTV Flash Image"
  IDS_DTV_ROM                     "DTV ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM &image File"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Enable &writes to DTV ROM image"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV Settings"
  IDS_DTV_REVISION_LABEL          "DTV Revision"
  IDS_ENABLE_HUMMER_ADC           "Enable Hummer ADC"
  IDS_CREATE_FLASH_CAPTION        "Create DTV Flash Image"
  IDS_DTV_ROM_CREATION            "DTV ROM Creation"
  IDS_C64DTV_ROM_COPY_C64         "Copy C64 ROMS into image"
  IDS_CREATE                      "Create"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV flash &rom image"
  IDS_MI_AUTOSTART_DISK           "&Autostart disk image..."
  IDS_MI_ATTACH_DTV_FLASH         "Attach &flash rom image"
  IDS_MI_DETACH_DTV_FLASH         "&Detach flash rom image"
  IDS_MI_CREATE_DTV_FLASH         "&Create new flash rom image"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&True flash filesystem"
  IDS_MI_PS2MOUSE                 "&PS/2 mouse emulation"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV settings..."
  IDS_JOYSTICK                    "Joystick"
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_SWEDISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "Anslut en DTV-flashavbildningsfil"
  IDS_DTV_ROM                     "DTV-ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM-&avbildningsfil"
  IDS_C64DTV_ROM_WRITE_ENABLE     "Aktivera &skrivning till DTV-ROM-avbildning"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV-instllningar"
  IDS_DTV_REVISION_LABEL          "DTV-utgva"
  IDS_ENABLE_HUMMER_ADC           "Aktivera Hummer-A/D-omvandlare"
  IDS_CREATE_FLASH_CAPTION        "Skapa DTV-flashavbildning"
  IDS_DTV_ROM_CREATION            "Skapa DTV-ROM"
  IDS_C64DTV_ROM_COPY_C64         "Kopiera C64-ROM:ar till avbild"
  IDS_CREATE                      "Skapa"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "Avbildningsfil fr DTV-flash&rom"
  IDS_MI_AUTOSTART_DISK           "&Autostarta diskettavbildning..."
  IDS_MI_ATTACH_DTV_FLASH         "Anslut &flash-rom-avbildningsfil"
  IDS_MI_DETACH_DTV_FLASH         "&Skapa ny flash-rom-avbildningsfil"
  IDS_MI_CREATE_DTV_FLASH         "&Create new flash rom image"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "&kta flash-filsystem"
  IDS_MI_PS2MOUSE                 "&PS/2-musemulering"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV-instllningar..."
  IDS_JOYSTICK                    "Styrspak"
END



#pragma code_page(28599)
STRINGTABLE
LANGUAGE LANG_TURKISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FLASH_CAPTION        "DTV Flash Imaj Yerletir"
  IDS_DTV_ROM                     "DTV ROM"
  IDS_C64DTV_ROM_IMAGE_FILE_LABEL "DTV ROM &imaj Dosyas"
  IDS_C64DTV_ROM_WRITE_ENABLE     "DTV ROM imajnda &yazmalar aktif et"
  IDS_C64DTV_SETTINGS_CAPTION     "C64DTV Ayarlar"
  IDS_DTV_REVISION_LABEL          "DTV Revizyonu"
  IDS_ENABLE_HUMMER_ADC           "Hummer ADC'yi aktif et"
  IDS_CREATE_FLASH_CAPTION        "DTV Flash Imaj Olutur"
  IDS_DTV_ROM_CREATION            "DTV ROM Yaratma"
  IDS_C64DTV_ROM_COPY_C64         "C64 ROMlarn imaja kopyala"
  IDS_CREATE                      "Yarat"
  IDS_MP_DTV_FLASH_ROM_IMAGE      "DTV flash &rom imaj"
  IDS_MI_AUTOSTART_DISK           "Disk imajn otom&atik balat..."
  IDS_MI_ATTACH_DTV_FLASH         "&Flash rom imaj yerletir"
  IDS_MI_DETACH_DTV_FLASH         "Flash rom imajn &kart"
  IDS_MI_CREATE_DTV_FLASH         "&Yeni flash rom imaj olutur"
  IDS_MI_FLASH_TRUE_FILESYSTEM    "Gerek flash dosya sis&temi"
  IDS_MI_PS2MOUSE                 "&PS/2 mouse emlasyonu"
  IDS_MI_C64DTV_SETTINGS          "&C64DTV ayarlar..."
  IDS_JOYSTICK                    "Joystick"
END
#pragma code_page(28591)
