/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License

Based on Telepathy-SNOM with copyright notice below.
*/

/*
 * Telepathy SNOM VoIP phone connection manager
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redisQObject::tribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is disQObject::tributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin SQObject::treet, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QtCore/QCoreApplication>
#include <QtCore/QDebug>

#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMetaType>
#include <QtDBus/QDBusInterface>
#include <QDBusError>
#include <QDateTime>

#include "names.h"
#include "connectionmanager.h"
#include "basetypes.h"
#include "connectionmanagertypes.h"
#include "connectiontypes.h"
#include "connectioninterfacerequeststypes.h"
#include "connectioninterfacecapabilitiestypes.h"


using namespace std;

int main(int argc, char ** argv)
{

    QCoreApplication app(argc, argv);

    // register types:
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ParameterDefinition>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ParameterDefinitionList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ChannelInfo>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ChannelInfoList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ChannelDetails>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ChannelDetailsList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ContactCapabilities>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ContactCapabilitiesList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::CapabilityPair>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::CapabilityPairList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::CapabilityChange>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::CapabilityChangeList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::RequestableChannelClass>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::RequestableChannelClassList>();

    QDBusConnection connection = QDBusConnection::sessionBus();

    if (!connection.interface()->isServiceRegistered(cm_service_name))
    {

        // register CM on D-BUS:
        bool success = connection.registerService(cm_service_name);
        if (success){
            qDebug(qPrintable(QObject::tr("Vicar-Telepathy: Service %1 registered with session bus.").
                       arg(cm_service_name)));
        }
        else{

            QDBusError error = connection.interface()->lastError();

            qDebug(qPrintable(QObject::tr("Vicar-Telepathy: Unable to register service %1 with session bus due to error %2.").
                       arg(cm_service_name,error.message())));
        }

    }

    ConnectionManager connection_mgr(&app);
    if (!connection.registerObject(cm_object_path,&connection_mgr)){
        qDebug(qPrintable(QObject::tr("Vicar-Telepathy: Unable to register VICaR connection manager at path %1 with session bus.").
                   arg(cm_object_path)));
    }

    qDebug(qPrintable(QObject::tr("Vicar-Telepathy: Enternig main loop.")));
    return app.exec();
}
