/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#if defined(Q_WS_MAEMO_6)

#include "harmattanaccountutility.h"
#include <Accounts/Manager>
#include <Accounts/Provider>
#include <Accounts/Service>
#include <QDebug>

#define SERVICE_NAME "vicar"
#define SERVICE_TYPE "IM"  //CRITICAL to display on contact page
#define PROVIDER_NAME "vicar"


using namespace Accounts;

HarmattanAccountUtility::HarmattanAccountUtility()
{
    manager = new Manager(this);    
}

Account* HarmattanAccountUtility::getAccount(){
    Account *vicarAccount = NULL;
    //AccountIdList accountsList = manager->accountList(SERVICE_TYPE);
    AccountIdList accountsList = manager->accountList();

    for (int i = 0; i < accountsList.size(); i++) {
        Account *tempAccount = manager->account(accountsList.at(i));        
        if (tempAccount->providerName() == PROVIDER_NAME){
            qDebug() << "Account exists";
            return tempAccount;
        }
        else {
            qDebug () << tempAccount->valueAsString("username") << "with provider " << tempAccount->providerName() <<" ignored";
        }
    }

    qDebug() << "Account does not exist";
    return vicarAccount;
}

Account* HarmattanAccountUtility::addAccount(){
    Account *vicarAccount;
    vicarAccount = getAccount();
    if (vicarAccount == NULL){
        qDebug() << "Creating new account";
        vicarAccount = manager->createAccount(PROVIDER_NAME);
        if (vicarAccount != NULL) {
            qDebug() << "Account object created";
            connect(vicarAccount,SIGNAL(error(Accounts::Error)),SLOT(errorOccurred(Accounts::Error)));
            vicarAccount->setDisplayName("VicarAccount");
            vicarAccount->setValue("username","vicar");
            vicarAccount->setValue("name","Call via Vicar");
            vicarAccount->setEnabled(true); //Set account as enabled globally
            Service *vicarService = manager->service(SERVICE_NAME);
            vicarAccount->selectService(vicarService);
            vicarAccount->setEnabled(true); //Set account as enabled at service level
            vicarAccount->setValue("ConnectAutomatically","true");
            vicarAccount->setValue("HasBeenOnline","true");
            vicarAccount->setValue("NormalizedName","Vicar");
            vicarAccount->setValue("org.freedesktop.Telepathy.Account.Interface.Addressing.DRAFT.URISchemes","tel;");  //CRITICAL to display on contact page
            vicarAccount->setValue("tmc-uid","vicar/tel/vicar0");
            vicarAccount->sync();
            qDebug() << "Account created with ID " << vicarAccount->id();
        }
        else{
            qDebug() << "Account not created due to error "<< manager->lastError().message();
        }
    }
    else{
        qDebug() << "Account already exists. No need to create again";
    }
    return vicarAccount;
}

void HarmattanAccountUtility::removeAccount(){
  Account *vicarAccount = getAccount();
  if (vicarAccount != NULL && vicarAccount != 0){
      vicarAccount->remove();
      vicarAccount->sync();
      qDebug() << "Account deleted";
      delete vicarAccount;
  }
}

void HarmattanAccountUtility::verifyAccount(){
    Account *vicarAccount = getAccount();
    if (vicarAccount != NULL && vicarAccount != 0){
        Service *vicarService = manager->service(SERVICE_NAME);
        vicarAccount->selectService(vicarService);
        QStringList keysList = vicarAccount->allKeys();
        qDebug() << keysList;
        delete vicarAccount;
    }
}

void HarmattanAccountUtility::errorOccurred(Accounts::Error error){
    qDebug() << "Error is "<< error.message();
}

#endif //defined(Q_WS_MAEMO_6)
