/*
@version: 0.1
@author: Sudheer K. <scifi.guy@hotmail.com>
@license: GNU General Public License
*/

#include <QtCore/QCoreApplication>
#include <QDBusConnection>
#include <QDebug>
#include "callrouter.h"
#include "gconfutility.h"

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    CallRouter callRouter(&a);
    callRouter.registerDBusService();
    qDebug() << "Registered DBus Service " << APPLICATION_DBUS_SERVICE;

    GConfUtility *gconfUtility = new GConfUtility();
    //If International call routing is already enabled, start monitoring calls
    //Otherwise wait for the signal from the configuration app
    if (gconfUtility->getGconfValueBoolean((char *)"routing_enabled")){
        qDebug() << "Call routing enabled. Starting call monitor..";
        callRouter.startOutgoingCallMonitor();
    }

    delete gconfUtility;
    gconfUtility = 0;

    return a.exec();          
}
