#ifndef __CBITMAPHANDLER_H__
#define __CBITMAPHANDLER_H__


#include "../global.h"
struct SDL_Surface;
class CLodHandler;

/*
 * CBitmapHandler.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */

enum Epcxformat {PCX8B, PCX24B};

struct BMPPalette
{
	unsigned char R,G,B,F;
};

class CPCXConv
{	
public:
	unsigned char * pcx, *bmp;
	int pcxs, bmps;
	void fromFile(std::string path);
	void saveBMP(std::string path) const;
	void openPCX(char * PCX, int len);
	SDL_Surface * getSurface() const; //for standard H3 PCX
	//SDL_Surface * getSurfaceZ(); //for ZSoft PCX
	CPCXConv() //c-tor
	: pcx(NULL), bmp(NULL), pcxs(0), bmps(0)
	{}
	~CPCXConv() //d-tor
	{
		if (pcxs) delete[] pcx;
		if (bmps) delete[] bmp;
	}
};

namespace BitmapHandler
{
	SDL_Surface * loadBitmap(std::string fname, bool setKey=true);
};

#endif // __CBITMAPHANDLER_H__
