#ifndef __CCASTLEINTERFACE_H__
#define __CCASTLEINTERFACE_H__



#include "../global.h"
#include <SDL.h>
#include "GUIBase.h"
#include "../hch/CMusicBase.h"
//#include "boost/tuple/tuple.hpp"
class CGTownInstance;
class CTownHandler;
class CHallInterface;
struct Structure;
class CSpell;
class AdventureMapButton;
class CResDataBar;
class CStatusBar;
class CTownList;
class CRecruitmentWindow;
class CTransformerWindow;
class CCreaturePic;
class CMinorResDataBar;

/*
 * CCastleInterface.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */

class CBuildingRect : public CIntObject
{
public:
	bool moi; //motion interested is active
	int offset, max; //first and last animation frame
	Structure* str;
	CDefHandler* def;
	SDL_Surface* border;
	SDL_Surface* area;
	CBuildingRect(Structure *Str); //c-tor
	~CBuildingRect(); //d-tor
	void activate();
	void deactivate();
	bool operator<(const CBuildingRect & p2) const;
	void hover(bool on);
	void clickLeft(tribool down, bool previousState);
	void clickRight(tribool down, bool previousState);
	void mouseMoved (const SDL_MouseMotionEvent & sEvent);
};

class CHeroGSlot : public CIntObject
{
public:
	CCastleInterface *owner;
	const CGHeroInstance *hero;
	int upg; //0 - up garrison, 1 - down garrison
	bool highlight; //indicates id the slot is highlighted

	void setHighlight(bool on);

	void hover (bool on);
	void clickRight(tribool down, bool previousState);
	void clickLeft(tribool down, bool previousState);
	void activate();
	void deactivate();
	void show(SDL_Surface * to);
	CHeroGSlot(int x, int y, int updown, const CGHeroInstance *h,CCastleInterface * Owner); //c-tor
	~CHeroGSlot(); //d-tor
};

class CCastleInterface : public CWindowWithGarrison
{
	class CCreaInfo : public CIntObject
	{
	public:
		int crid,level;
		CCreaInfo(int CRID, int LVL); //c-tor
		~CCreaInfo();//d-tor
		int AddToString(std::string from, std::string & to, int numb);
		void hover(bool on);
		void clickLeft(tribool down, bool previousState);
		void clickRight(tribool down, bool previousState);
		void show(SDL_Surface * to);
	};
	class CTownInfo : public CIntObject
	{
	public:
		int bid;//typeID
		CDefHandler * pic;
		CTownInfo(int BID); //c-tor
		~CTownInfo();//d-tor
		void hover(bool on);
		void clickLeft(tribool down, bool previousState);
		void clickRight(tribool down, bool previousState);
		void show(SDL_Surface * to);
	};
public:
	bool showing; //indicates if interface is active
	CBuildingRect * hBuild; //highlighted building
	SDL_Surface * townInt;
	SDL_Surface * cityBg;
	const CGTownInstance * town;
	CStatusBar * statusbar;
	CResDataBar *resdatabar;
	unsigned char animval, count;
	int winMode;//0=right-click popup, 1 = normal, 2 = town hall only, 3 = fort only;

	CDefEssential *bars, //0 - yellow, 1 - green, 2 - red, 3 - gray
		*status; //0 - already, 1 - can't, 2 - lack of resources
	CTownInfo *hall,*fort,*market;
	CDefEssential* bicons; //150x70 buildings imgs
	CTownList * townlist;

	CHeroGSlot hslotup, hslotdown;
	AdventureMapButton *exit;
	AdventureMapButton *split;

	musicBase::musicID musicID;
	std::vector<CCreaInfo*> creainfo;//small icons of creatures (bottom-left corner);
	std::vector<CBuildingRect*> buildings; //building id, building def, structure struct, border, filling

	CCastleInterface(const CGTownInstance * Town, int listPos = 1); //c-tor
	~CCastleInterface(); //d-tor

	void castleTeleport(int where);
	void townChange();
	void keyPressed(const SDL_KeyboardEvent & key);
	void show(SDL_Surface * to);
	void showAll(SDL_Surface * to);
	void buildingClicked(int building);
	void defaultBuildingClicked(int building);//for buildings with simple description + pic left-click messages
	void enterFountain(int building);
	void enterBlacksmith(int ArtifactID);//support for blacksmith + ballista yard
	void enterTavern();
	void enterMageGuild();
	void splitClicked(); //for hero meeting (splitting stacks is handled by garrison int)
	void showRecruitmentWindow( int level );
	void enterHall();
	void close();
	void splitF();
	void activate();
	void deactivate();
	void addBuilding(int bid);
	void removeBuilding(int bid);
	void recreateBuildings();
	void recreateIcons();
};
class CHallInterface : public IShowActivable
{
public:
	CMinorResDataBar * resdatabar;
	SDL_Rect pos;

	class CBuildingBox : public CIntObject
	{
	public:
		int BID;
		int state;// 0 - no more than one capitol, 1 - lack of water, 2 - forbidden, 3 - Add another level to Mage Guild, 4 - already built, 5 - already builded today, 6 - cannot afford, 7 - build, 8 - lack of requirements
		//(-1) - forbidden in this town, 0 - possible, 1 - lack of res, 2 - requirements/buildings per turn limit, (3) - already exists
		void hover(bool on);
		void clickLeft(tribool down, bool previousState);
		void clickRight(tribool down, bool previousState);
		void show(SDL_Surface * to);
		CBuildingBox(int id); //c-tor
		CBuildingBox(int id, int x, int y); //c-tor
		~CBuildingBox(); //d-tor
	};

	class CBuildWindow: public CIntObject
	{
	public:
		int tid, bid, state; //town id, building id, state
		bool mode; // 0 - normal (with buttons), 1 - r-click popup
		SDL_Surface * bitmap; //main window bitmap, with blitted res/text, without buttons/subtitle in "statusbar"
		AdventureMapButton *buy, *cancel;

		void activate();
		void deactivate();
		std::string getTextForState(int state);
		void clickRight(tribool down, bool previousState);
		void show(SDL_Surface * to);
		void Buy();
		void close();
		CBuildWindow(int Tid, int Bid, int State, bool Mode); //c-tor
		~CBuildWindow(); //d-tor
	};

	std::vector< std::vector<CBuildingBox*> >boxes;

	AdventureMapButton *exit;

	SDL_Surface * bg; //background
	int bid;//building ID

	CHallInterface(CCastleInterface * owner); //c-tor
	~CHallInterface(); //d-tor
	void close();
	void show(SDL_Surface * to);
	void activate();
	void deactivate();
};

class CFortScreen : public CIntObject
{
	class RecArea : public CIntObject
	{
	public:
		int level;
		RecArea(int LEVEL):level(LEVEL){used = LCLICK | RCLICK;}; //c-tor
		void clickLeft(tribool down, bool previousState);
		void clickRight(tribool down, bool previousState);
	};
public:
	CMinorResDataBar * resdatabar;
	int fortSize;
	AdventureMapButton *exit;
	SDL_Surface * bg;
	std::vector<Rect> positions;
	std::vector<RecArea*> recAreas;
	std::vector<CCreaturePic*> crePics;

	CFortScreen(CCastleInterface * owner); //c-tor

	void draw( CCastleInterface * owner, bool first);
	~CFortScreen(); //d-tor
	void close();
	void show(SDL_Surface * to);
	void activate();
	void deactivate();
};

class CMageGuildScreen : public CIntObject
{
public:
	class Scroll : public CIntObject
	{
	public:
		CSpell *spell;

		Scroll(CSpell *Spell):spell(Spell){used = LCLICK | RCLICK | HOVER;};
		void clickLeft(tribool down, bool previousState);
		void clickRight(tribool down, bool previousState);
		void hover(bool on);
	};
	std::vector<std::vector<SDL_Rect> > positions;

	SDL_Surface *bg;
	CDefEssential *scrolls, *scrolls2;
	AdventureMapButton *exit;
	std::vector<Scroll> spells;
	CMinorResDataBar * resdatabar;


	CMageGuildScreen(CCastleInterface * owner); //c-tor
	~CMageGuildScreen(); //d-tor
	void close();
	void show(SDL_Surface * to);
	void activate();
	void deactivate();
};

class CBlacksmithDialog : public CIntObject
{
public:
	AdventureMapButton *buy, *cancel;
	SDL_Surface *bmp; //background

	CBlacksmithDialog(bool possible, int creMachineID, int aid, int hid); //c-tor
	~CBlacksmithDialog(); //d-tor
	void close();
	void show(SDL_Surface * to);
	void activate();
	void deactivate();
};

#endif // __CCASTLEINTERFACE_H__
