map_data = {}

-- The number of rows, and columns that compose the map
map_data.num_tile_cols = 32
map_data.num_tile_rows = 24

-- The tilesets definition files used.
map_data.tileset_filenames = {}
map_data.tileset_filenames[1] = "dat/tilesets/mountain_house_exterior.lua"
map_data.tileset_filenames[2] = "dat/tilesets/mountain_house_exterior2.lua"
map_data.tileset_filenames[3] = "dat/tilesets/mountain_landscape.lua"
map_data.tileset_filenames[4] = "dat/tilesets/water_tileset.lua"
map_data.tileset_filenames[5] = "dat/tilesets/harrvah_house_exterior.lua"
map_data.tileset_filenames[6] = "dat/tilesets/village_exterior.lua"

-- The map grid to indicate walkability. 0 is walkable, 1 is not.
map_data.map_grid = {}
map_data.map_grid[0] = { 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[1] = { 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0 }
map_data.map_grid[2] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[3] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[4] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[5] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[6] = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[7] = { 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[8] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[10] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[12] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[13] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 }
map_data.map_grid[14] = { 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[15] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[16] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[17] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1 }
map_data.map_grid[18] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[19] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[20] = { 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[21] = { 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1 }
map_data.map_grid[22] = { 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[23] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[24] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[25] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1 }
map_data.map_grid[26] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[27] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0 }
map_data.map_grid[28] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[29] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[30] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[31] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[32] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[33] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[34] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[35] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[36] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_data.map_grid[37] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[38] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_data.map_grid[39] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 }
map_data.map_grid[40] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_data.map_grid[41] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0 }
map_data.map_grid[42] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[43] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[44] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[45] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_data.map_grid[46] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0 }
map_data.map_grid[47] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }

-- The tile layers. The numbers are indeces to the tile_mappings table.
map_data.layers = {}
map_data.layers[0] = {}
map_data.layers[0].type = "ground"
map_data.layers[0].name = "Background"
map_data.layers[0][0] = { 591, 590, 591, 606, 590, 607, 591, 606, 606, 591, 607, 590, 606, 606, 607, 591, 607, 606, 591, 591, 607, 591, 607, 591, 607, 606, 590, 607, 606, 606, 607, 607 }
map_data.layers[0][1] = { 607, 607, 591, 607, 591, 606, 591, 590, 607, 590, 591, 606, 606, 523, 524, 525, 591, 607, 591, 607, 607, 590, 590, 590, 607, 591, 590, 591, 606, 590, 606, 607 }
map_data.layers[0][2] = { 591, 591, 607, 606, 591, 607, 590, 590, 590, 606, 606, 591, 591, 555, 638, 623, 525, 591, 590, 590, 607, 590, 606, 607, 607, 606, 607, 590, 590, 591, 591, 607 }
map_data.layers[0][3] = { 590, 606, 591, 591, 607, 607, 590, 606, 591, 590, 606, 591, 591, 591, 539, 540, 541, 606, 591, 607, 590, 607, 590, 590, 606, 590, 607, 590, 591, 590, 607, 590 }
map_data.layers[0][4] = { 591, 590, 591, 591, 590, 590, 607, 606, 590, 606, 607, 606, 607, 607, 555, 556, 557, 606, 591, 607, 591, 590, 590, 590, 591, 607, 590, 606, 591, 607, 591, 606 }
map_data.layers[0][5] = { 606, 606, 591, 591, 607, 591, 607, 591, 606, 607, 590, 590, 607, 607, 590, 606, 607, 607, 607, 590, 590, 591, 606, 590, 607, 607, 590, 606, 590, 591, 607, 590 }
map_data.layers[0][6] = { 607, 591, 590, 590, 607, 606, 606, 591, 606, 607, 590, 607, 606, 607, 590, 607, 607, 607, 607, 591, 606, 607, 590, 607, 590, 606, 606, 606, 606, 606, 590, 591 }
map_data.layers[0][7] = { 590, 591, 591, 591, 591, 607, 606, 591, 606, 590, 590, 607, 606, 607, 524, 525, 606, 607, 606, 591, 607, 606, 591, 590, 590, 590, 591, 607, 591, 590, 590, 607 }
map_data.layers[0][8] = { 607, 591, 607, 591, 523, 524, 607, 607, 591, 606, 606, 607, 591, 606, 607, 590, 591, 607, 590, 590, 606, 590, 606, 607, 607, 590, 590, 0, 590, 590, 591, 606 }
map_data.layers[0][9] = { 590, 591, 591, 591, 539, 571, 590, 607, 591, 591, 607, 591, 607, 591, 607, 607, 639, 557, 523, 524, 607, 606, 591, 607, 590, 591, 606, 607, 524, 525, 607, 591 }
map_data.layers[0][10] = { 590, 591, 607, 591, 539, 587, 607, 607, 591, 606, 590, 591, 607, 591, 590, 591, 541, 591, 539, 571, 591, 606, 607, 591, 606, 606, 606, 590, 573, 541, 607, 590 }
map_data.layers[0][11] = { 591, 607, 590, 590, 539, 587, 607, 591, 590, 590, 590, 590, 591, 606, 590, 607, 541, 606, 539, 587, 607, 591, 590, 607, 606, 606, 607, 606, 589, 623, 524, 525 }
map_data.layers[0][12] = { 607, 590, 591, 606, 539, 587, 607, 607, 590, 591, 606, 591, 606, 607, 606, 606, 541, 590, 539, 587, 607, 591, 607, 607, 591, 590, 607, 591, 589, 540, 554, 554 }
map_data.layers[0][13] = { 591, 606, 591, 590, 539, 587, 591, 591, 591, 606, 590, 590, 606, 606, 607, 607, 623, 525, 539, 587, 607, 606, 606, 607, 606, 606, 591, 591, 589, 540, 639, 557 }
map_data.layers[0][14] = { 591, 591, 607, 591, 539, 587, 543, 606, 590, 591, 607, 591, 607, 526, 526, 589, 522, 623, 622, 587, 543, 606, 606, 607, 606, 606, 591, 588, 589, 639, 557, 607 }
map_data.layers[0][15] = { 606, 607, 591, 590, 622, 587, 543, 606, 591, 606, 591, 607, 606, 543, 575, 605, 538, 538, 522, 587, 588, 606, 607, 606, 606, 607, 607, 527, 589, 541, 607, 590 }
map_data.layers[0][16] = { 606, 590, 606, 590, 538, 603, 574, 543, 606, 607, 607, 591, 526, 542, 605, 639, 638, 538, 522, 587, 588, 526, 606, 590, 607, 590, 526, 543, 589, 541, 591, 590 }
map_data.layers[0][17] = { 591, 606, 591, 591, 556, 638, 603, 574, 542, 542, 526, 542, 575, 605, 639, 557, 555, 638, 538, 603, 604, 604, 604, 604, 604, 604, 604, 604, 605, 541, 607, 607 }
map_data.layers[0][18] = { 606, 606, 590, 590, 606, 555, 638, 603, 604, 604, 604, 604, 605, 639, 557, 606, 591, 539, 554, 540, 639, 556, 556, 556, 556, 556, 556, 556, 556, 557, 590, 606 }
map_data.layers[0][19] = { 590, 606, 590, 607, 606, 591, 555, 556, 556, 556, 556, 556, 556, 557, 607, 590, 607, 539, 554, 554, 541, 606, 607, 590, 591, 590, 590, 606, 590, 590, 590, 606 }
map_data.layers[0][20] = { 591, 591, 606, 591, 606, 590, 606, 590, 590, 591, 606, 606, 539, 522, 541, 591, 606, 539, 522, 554, 541, 606, 606, 539, 554, 541, 607, 525, 591, 591, 590, 607 }
map_data.layers[0][21] = { 525, 590, 523, 524, 524, 524, 524, 524, 524, 524, 525, 606, 555, 556, 557, 590, 590, 590, 606, 607, 590, 606, 607, 555, 556, 557, 555, 557, 523, 524, 525, 606 }
map_data.layers[0][22] = { 541, 607, 539, 606, 591, 606, 606, 590, 606, 591, 590, 590, 607, 590, 590, 607, 607, 606, 591, 606, 591, 590, 606, 606, 606, 590, 607, 523, 622, 554, 623, 606 }
map_data.layers[0][23] = { 557, 591, 555, 638, 538, 522, 522, 522, 639, 556, 557, 590, 590, 607, 590, 607, 590, 591, 590, 590, 606, 590, 607, 606, 590, 590, 591, 554, 522, 522, 554, 606 }

map_data.layers[1] = {}
map_data.layers[1].type = "ground"
map_data.layers[1].name = "Background 2"
map_data.layers[1][0] = { 529, 530, 531, 532, 533, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 528, 529 }
map_data.layers[1][1] = { 545, 546, 547, 548, 549, 1350, 1350, -1, 1333, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1333, -1, 1335, -1, -1, -1, -1, -1, -1, -1, 1333, -1, 576, 577 }
map_data.layers[1][2] = { 561, 562, 563, 564, 565, -1, 1350, 1350, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1335, 1334, 1334, 1335, -1, -1, 523, 524, 525, -1, -1, 560, 561 }
map_data.layers[1][3] = { 577, 578, 579, 580, 581, -1, 1335, -1, 1350, -1, 1334, -1, -1, -1, -1, -1, -1, -1, -1, 1333, 1333, 1335, -1, -1, -1, 539, 540, 541, -1, 1334, 576, 577 }
map_data.layers[1][4] = { 593, 594, 595, 596, 597, -1, -1, -1, -1, -1, -1, 1350, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 555, 556, 557, -1, -1, 592, 593 }
map_data.layers[1][5] = { 609, 610, 611, 612, 613, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1351, -1, -1, -1, -1, -1, 1350, 1350, -1, -1, -1, -1, -1, -1, 608, 609 }
map_data.layers[1][6] = { 515, 516, 1351, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, -1, -1, 523, 524, 525, -1, -1, -1, -1, -1, 1350, -1, -1, -1, -1, -1, -1, 756 }
map_data.layers[1][7] = { 531, 532, 533, -1, -1, -1, 49, 50, 51, 52, 53, 54, 55, 56, -1, -1, 539, 540, 541, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 740 }
map_data.layers[1][8] = { 547, 548, 549, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, 589, 623, 622, 639, 557, -1, 33, 34, 35, 36, 37, 38, 39, 40, -1, -1, -1, 756 }
map_data.layers[1][9] = { 563, 564, 565, -1, -1, -1, 49, 50, 51, 52, 53, 54, 55, 56, 559, 573, -1, -1, -1, -1, 49, 50, 51, 52, 53, 54, 55, 56, -1, -1, -1, 740 }
map_data.layers[1][10] = { 584, 585, 581, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 526, 589, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, -1, -1, -1, 756 }
map_data.layers[1][11] = { 600, 601, 597, -1, -1, -1, 161, 162, 163, 14, 15, 166, 167, 168, 526, 589, -1, -1, -1, -1, 161, 162, 163, 164, 165, 166, 167, 168, -1, -1, -1, 740 }
map_data.layers[1][12] = { 616, 617, 1350, -1, -1, -1, 177, 178, 179, 180, 181, 182, 183, 184, 588, 589, -1, 1335, -1, -1, 177, 178, 179, 180, 181, 182, 183, 184, 1299, -1, 512, 756 }
map_data.layers[1][13] = { -1, 1350, -1, -1, -1, -1, 193, 194, 195, 46, 47, 198, 199, 200, 527, 589, -1, -1, -1, -1, 193, 194, 195, 46, 47, 198, 199, 200, 1299, -1, 528, 529 }
map_data.layers[1][14] = { -1, -1, -1, 1350, -1, -1, 209, 210, 211, 62, 63, 214, 215, 216, 1299, -1, -1, -1, -1, -1, 209, 210, 211, 62, 63, 214, 215, 216, 1299, -1, 544, 545 }
map_data.layers[1][15] = { 1337, 523, 524, 524, -1, -1, 225, 226, 227, 78, 79, 230, 231, 232, -1, -1, -1, -1, -1, -1, 225, 226, 227, 78, 79, 230, 231, 232, -1, -1, 560, 561 }
map_data.layers[1][16] = { 523, 622, 540, 540, -1, -1, 241, 242, 243, 94, 95, 246, 247, 248, -1, -1, -1, -1, -1, -1, 241, 242, 243, 94, 95, 246, 247, 248, -1, -1, 576, 577 }
map_data.layers[1][17] = { 539, 540, 540, 639, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 592, 593 }
map_data.layers[1][18] = { 555, 638, 540, 541, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 608, 609 }
map_data.layers[1][19] = { -1, 555, 556, 557, 1337, -1, -1, -1, -1, -1, -1, 317, -1, -1, -1, -1, 480, -1, -1, -1, -1, 485, -1, -1, -1, -1, 286, -1, -1, -1, 1335, 513 }
map_data.layers[1][20] = { -1, 1337, -1, 1337, -1, 316, 1337, 1337, -1, -1, 1340, 333, 398, 347, 398, 302, 496, 539, 554, 538, 541, 501, 302, 398, 347, 398, 302, -1, -1, -1, 528, 529 }
map_data.layers[1][21] = { -1, -1, 364, 332, 364, 332, 364, 331, 364, 382, -1, 380, -1, -1, -1, -1, 523, 622, 554, 522, 623, 525, -1, -1, -1, -1, -1, -1, -1, -1, 544, 545 }
map_data.layers[1][22] = { 379, 442, 380, 348, 380, 348, 380, 347, 380, 398, 443, -1, 1336, 1353, 1354, 523, 622, 571, 572, 572, 573, 623, 525, -1, 1352, 1370, 380, -1, -1, -1, 427, 561 }
map_data.layers[1][23] = { -1, 1370, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1336, -1, 539, 571, 558, 527, 526, 559, 573, 541, 1369, 1370, -1, 302, 380, 398, 380, 398, 577 }

map_data.layers[2] = {}
map_data.layers[2].type = "ground"
map_data.layers[2].name = "Background 3"
map_data.layers[2][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 544, 545 }
map_data.layers[2][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 708 }
map_data.layers[2][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
map_data.layers[2][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
map_data.layers[2][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 708 }
map_data.layers[2][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
map_data.layers[2][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 708 }
map_data.layers[2][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
map_data.layers[2][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1299, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1299, 1300, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 110, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 110, 111, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, 127, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, 127, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 142, 143, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 142, 143, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[2][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 763, 763, 763, 763, -1, -1, -1, -1, -1, 429, -1, -1, -1, -1, -1 }
map_data.layers[2][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 287, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 428, -1, -1, -1, -1, -1 }
map_data.layers[2][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 303, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 560, -1 }
map_data.layers[2][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 576, -1 }

map_data.layers[3] = {}
map_data.layers[3].type = "sky"
map_data.layers[3].name = "Sky"
map_data.layers[3][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][4] = { -1, -1, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][5] = { -1, -1, -1, -1, -1, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][6] = { -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1 }
map_data.layers[3][7] = { -1, -1, -1, -1, -1, 48, -1, -1, -1, -1, -1, -1, -1, -1, 57, -1, -1, -1, -1, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1 }
map_data.layers[3][8] = { -1, -1, -1, -1, -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, 73, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, -1 }
map_data.layers[3][9] = { -1, -1, -1, -1, -1, 80, -1, -1, -1, -1, -1, -1, -1, -1, 89, -1, -1, -1, -1, 48, -1, -1, -1, -1, -1, -1, -1, -1, 57, -1, -1, -1 }
map_data.layers[3][10] = { -1, -1, -1, -1, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, 89, -1, -1, -1, -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, 73, -1, -1, -1 }
map_data.layers[3][11] = { -1, -1, -1, -1, -1, 160, -1, -1, -1, -1, -1, -1, -1, -1, 169, -1, -1, -1, -1, 80, -1, -1, -1, -1, -1, -1, -1, -1, 89, -1, -1, -1 }
map_data.layers[3][12] = { -1, -1, -1, -1, -1, 176, -1, -1, -1, -1, -1, -1, -1, -1, 185, -1, -1, -1, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, 185, -1, -1, -1 }
map_data.layers[3][13] = { -1, -1, -1, -1, -1, 192, -1, -1, -1, -1, -1, -1, -1, -1, 201, -1, -1, -1, -1, 192, -1, -1, -1, -1, -1, -1, -1, -1, 201, -1, -1, -1 }
map_data.layers[3][14] = { -1, -1, -1, -1, -1, 208, -1, -1, -1, -1, -1, -1, -1, -1, 217, -1, -1, -1, -1, 208, -1, -1, -1, -1, -1, -1, -1, -1, 217, -1, -1, -1 }
map_data.layers[3][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, -1, -1, -1, -1, 437, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 448, 449, 450, 451, 452, 453, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 366, 315, 366, -1, 464, -1, -1, -1, -1, 469, -1, 366, 316, 366, -1, -1, -1, -1, -1, -1 }
map_data.layers[3][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 317, 382, 331, 382, 286, -1, 747, 747, 747, 747, -1, 286, 382, 332, 382, 286, -1, -1, -1, -1, -1 }
map_data.layers[3][20] = { -1, 458, -1, 316, -1, 316, -1, 315, -1, 366, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 412, -1, -1, -1, -1, -1 }
map_data.layers[3][21] = { 363, 426, 364, 332, 364, 332, 364, 331, 364, 382, 427, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 366, -1, -1, -1 }
map_data.layers[3][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 286, 364, 382, 364, 427, -1 }
map_data.layers[3][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 443, -1 }

map_data.layers[4] = {}
map_data.layers[4].type = "sky"
map_data.layers[4].name = "sky2"
map_data.layers[4][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 236, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 236, 237, 238, 239, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 252, 253, 254, 255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 413, -1, -1, -1, -1, -1 }
map_data.layers[4][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
map_data.layers[4][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 560, -1 }
map_data.layers[4][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 576, -1 }

