/* valasymbol.c generated by valac, the Vala compiler
 * generated from valasymbol.vala, do not modify */

/* valasymbol.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

struct _ValaSymbolPrivate {
	char* _name;
	gboolean _active;
	gboolean _used;
	ValaSymbolAccessibility _access;
	gboolean _external;
	ValaScope* _owner;
	ValaScope* _scope;
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;


static gpointer vala_symbol_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_symbol_accessibility_get_type (void);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
#define VALA_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL, ValaSymbolPrivate))
enum  {
	VALA_SYMBOL_DUMMY_PROPERTY
};
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gboolean vala_symbol_is_internal_symbol (ValaSymbol* self);
gboolean vala_symbol_is_private_symbol (ValaSymbol* self);
ValaCodeNode* vala_code_node_construct (GType object_type);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaScope* vala_scope_new (ValaSymbol* owner);
ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner);
ValaSymbol* vala_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
const char* vala_symbol_get_name (ValaSymbol* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
static char* vala_symbol_real_get_cprefix (ValaSymbol* self);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_symbol_real_get_lower_case_cname (ValaSymbol* self, const char* infix);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_symbol_real_get_lower_case_cprefix (ValaSymbol* self);
GeeList* vala_symbol_get_cheader_filenames (ValaSymbol* self);
static GeeList* vala_symbol_real_get_cheader_filenames (ValaSymbol* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
char* vala_symbol_lower_case_to_camel_case (const char* lower_case);
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaScope* vala_symbol_get_top_accessible_scope (ValaSymbol* self, gboolean is_internal);
GType vala_member_get_type (void);
GType vala_field_get_type (void);
GType member_binding_get_type (void);
MemberBinding vala_field_get_binding (ValaField* self);
GType vala_method_get_type (void);
GType vala_creation_method_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_property_get_type (void);
MemberBinding vala_property_get_binding (ValaProperty* self);
GType vala_enum_value_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_error_code_get_type (void);
gboolean vala_symbol_is_instance_member (ValaSymbol* self);
static gboolean vala_symbol_real_is_instance_member (ValaSymbol* self);
gboolean vala_symbol_is_class_member (ValaSymbol* self);
static gboolean vala_symbol_real_is_class_member (ValaSymbol* self);
ValaSymbol* vala_scope_get_owner (ValaScope* self);
void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
gboolean vala_symbol_get_active (ValaSymbol* self);
void vala_symbol_set_active (ValaSymbol* self, gboolean value);
gboolean vala_symbol_get_used (ValaSymbol* self);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_symbol_set_external (ValaSymbol* self, gboolean value);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
gboolean vala_source_file_get_external_package (ValaSourceFile* self);
static void vala_symbol_finalize (ValaCodeNode* obj);



static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


gboolean vala_symbol_is_internal_symbol (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->_external) {
		_tmp0_ = vala_symbol_get_external_package (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* sym;
		sym = _vala_code_node_ref0 (self);
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				if (!_tmp1_) {
					ValaSymbol* _tmp2_;
					sym = (_tmp2_ = _vala_code_node_ref0 (vala_symbol_get_parent_symbol (sym)), _vala_code_node_unref0 (sym), _tmp2_);
				}
				_tmp1_ = FALSE;
				if (!(NULL != sym)) {
					break;
				}
				if (sym->priv->_access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = sym->priv->_access == VALA_SYMBOL_ACCESSIBILITY_INTERNAL;
				}
				if (_tmp3_) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}


gboolean vala_symbol_is_private_symbol (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->_external) {
		_tmp0_ = vala_symbol_get_external_package (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* sym;
		sym = _vala_code_node_ref0 (self);
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					ValaSymbol* _tmp2_;
					sym = (_tmp2_ = _vala_code_node_ref0 (vala_symbol_get_parent_symbol (sym)), _vala_code_node_unref0 (sym), _tmp2_);
				}
				_tmp1_ = FALSE;
				if (!(NULL != sym)) {
					break;
				}
				if (sym->priv->_access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}


ValaSymbol* vala_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaSymbol* self;
	ValaScope* _tmp0_;
	self = (ValaSymbol*) vala_code_node_construct (object_type);
	vala_symbol_set_name (self, name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	self->priv->_scope = (_tmp0_ = vala_scope_new (self), _vala_scope_unref0 (self->priv->_scope), _tmp0_);
	return self;
}


char* vala_symbol_get_full_name (ValaSymbol* self) {
	char* result;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_symbol_get_parent_symbol (self) == NULL) {
		result = g_strdup (self->priv->_name);
		return result;
	}
	if (self->priv->_name == NULL) {
		result = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (self));
		return result;
	}
	if ((_tmp1_ = (_tmp0_ = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (self))) == NULL, _g_free0 (_tmp0_), _tmp1_)) {
		result = g_strdup (self->priv->_name);
		return result;
	}
	result = (_tmp3_ = g_strdup_printf ("%s.%s", _tmp2_ = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (self)), self->priv->_name), _g_free0 (_tmp2_), _tmp3_);
	return result;
}


static char* vala_symbol_real_get_cprefix (ValaSymbol* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_name == NULL) {
		result = g_strdup ("");
		return result;
	} else {
		result = g_strdup (self->priv->_name);
		return result;
	}
}


char* vala_symbol_get_cprefix (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->get_cprefix (self);
}


static char* vala_symbol_real_get_lower_case_cname (ValaSymbol* self, const char* infix) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix) {
	return VALA_SYMBOL_GET_CLASS (self)->get_lower_case_cname (self, infix);
}


static char* vala_symbol_real_get_lower_case_cprefix (ValaSymbol* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup ("");
	return result;
}


char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->get_lower_case_cprefix (self);
}


static GeeList* vala_symbol_real_get_cheader_filenames (ValaSymbol* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	return result;
}


GeeList* vala_symbol_get_cheader_filenames (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->get_cheader_filenames (self);
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


char* vala_symbol_camel_case_to_lower_case (const char* camel_case) {
	char* result;
	GString* result_builder;
	const char* i;
	gboolean first;
	g_return_val_if_fail (camel_case != NULL, NULL);
	if (string_contains (camel_case, "_")) {
		result = g_utf8_strdown (camel_case, -1);
		return result;
	}
	result_builder = g_string_new ("");
	i = camel_case;
	first = TRUE;
	while (TRUE) {
		gunichar c;
		gboolean _tmp0_ = FALSE;
		if (!(g_utf8_strlen (i, -1) > 0)) {
			break;
		}
		c = g_utf8_get_char (i);
		if (g_unichar_isupper (c)) {
			_tmp0_ = !first;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			const char* t;
			gboolean prev_upper;
			gboolean next_upper;
			gboolean _tmp1_ = FALSE;
			t = g_utf8_prev_char (i);
			prev_upper = g_unichar_isupper (g_utf8_get_char (t));
			t = g_utf8_next_char (i);
			next_upper = g_unichar_isupper (g_utf8_get_char (t));
			if (!prev_upper) {
				_tmp1_ = TRUE;
			} else {
				gboolean _tmp2_ = FALSE;
				if (g_utf8_strlen (i, -1) >= 2) {
					_tmp2_ = !next_upper;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp1_ = _tmp2_;
			}
			if (_tmp1_) {
				glong len;
				gboolean _tmp3_ = FALSE;
				len = g_utf8_strlen (result_builder->str, -1);
				if (len != 1) {
					_tmp3_ = g_utf8_get_char (g_utf8_offset_to_pointer (result_builder->str, len - 2)) != '_';
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					g_string_append_c (result_builder, '_');
				}
			}
		}
		g_string_append_unichar (result_builder, g_unichar_tolower (c));
		first = FALSE;
		i = g_utf8_next_char (i);
	}
	result = g_strdup (result_builder->str);
	_g_string_free0 (result_builder);
	return result;
}


char* vala_symbol_lower_case_to_camel_case (const char* lower_case) {
	char* result;
	GString* result_builder;
	const char* i;
	gboolean last_underscore;
	g_return_val_if_fail (lower_case != NULL, NULL);
	result_builder = g_string_new ("");
	i = lower_case;
	last_underscore = TRUE;
	while (TRUE) {
		gunichar c;
		if (!(g_utf8_strlen (i, -1) > 0)) {
			break;
		}
		c = g_utf8_get_char (i);
		if (c == '_') {
			last_underscore = TRUE;
		} else {
			if (g_unichar_isupper (c)) {
				result = g_strdup (lower_case);
				_g_string_free0 (result_builder);
				return result;
			} else {
				if (last_underscore) {
					g_string_append_unichar (result_builder, g_unichar_toupper (c));
					last_underscore = FALSE;
				} else {
					g_string_append_unichar (result_builder, c);
				}
			}
		}
		i = g_utf8_next_char (i);
	}
	result = g_strdup (result_builder->str);
	_g_string_free0 (result_builder);
	return result;
}


static gpointer _vala_scope_ref0 (gpointer self) {
	return self ? vala_scope_ref (self) : NULL;
}


ValaScope* vala_symbol_get_top_accessible_scope (ValaSymbol* self, gboolean is_internal) {
	ValaScope* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		result = _vala_scope_ref0 (vala_symbol_get_owner (self));
		return result;
	}
	if (self->priv->_access == VALA_SYMBOL_ACCESSIBILITY_INTERNAL) {
		is_internal = TRUE;
	}
	if (vala_symbol_get_parent_symbol (self) == NULL) {
		if (is_internal) {
			result = _vala_scope_ref0 (vala_symbol_get_scope (self));
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	result = vala_symbol_get_top_accessible_scope (vala_symbol_get_parent_symbol (self), is_internal);
	return result;
}


static gboolean vala_symbol_real_is_instance_member (ValaSymbol* self) {
	gboolean result;
	gboolean instance;
	g_return_val_if_fail (self != NULL, FALSE);
	instance = TRUE;
	if (VALA_IS_FIELD (self)) {
		ValaField* f;
		f = _vala_code_node_ref0 (VALA_FIELD (self));
		instance = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
		_vala_code_node_unref0 (f);
	} else {
		if (VALA_IS_METHOD (self)) {
			ValaMethod* m;
			m = _vala_code_node_ref0 (VALA_METHOD (self));
			if (!VALA_IS_CREATION_METHOD (m)) {
				instance = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (VALA_IS_PROPERTY (self)) {
				ValaProperty* prop;
				prop = _vala_code_node_ref0 (VALA_PROPERTY (self));
				instance = vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE;
				_vala_code_node_unref0 (prop);
			} else {
				if (VALA_IS_ENUM_VALUE (self)) {
					instance = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (self)) {
						instance = FALSE;
					}
				}
			}
		}
	}
	result = instance;
	return result;
}


gboolean vala_symbol_is_instance_member (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->is_instance_member (self);
}


static gboolean vala_symbol_real_is_class_member (ValaSymbol* self) {
	gboolean result;
	gboolean isclass;
	g_return_val_if_fail (self != NULL, FALSE);
	isclass = TRUE;
	if (VALA_IS_FIELD (self)) {
		ValaField* f;
		f = _vala_code_node_ref0 (VALA_FIELD (self));
		isclass = vala_field_get_binding (f) == MEMBER_BINDING_CLASS;
		_vala_code_node_unref0 (f);
	} else {
		if (VALA_IS_METHOD (self)) {
			ValaMethod* m;
			m = _vala_code_node_ref0 (VALA_METHOD (self));
			if (!VALA_IS_CREATION_METHOD (m)) {
				isclass = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (VALA_IS_PROPERTY (self)) {
				ValaProperty* prop;
				prop = _vala_code_node_ref0 (VALA_PROPERTY (self));
				isclass = vala_property_get_binding (prop) == MEMBER_BINDING_CLASS;
				_vala_code_node_unref0 (prop);
			} else {
				if (VALA_IS_ENUM_VALUE (self)) {
					isclass = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (self)) {
						isclass = FALSE;
					}
				}
			}
		}
	}
	result = isclass;
	return result;
}


gboolean vala_symbol_is_class_member (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->is_class_member (self);
}


ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self) {
	ValaSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_symbol_get_owner (self) == NULL) {
		result = NULL;
		return result;
	} else {
		result = vala_scope_get_owner (vala_symbol_get_owner (self));
		return result;
	}
}


ValaScope* vala_symbol_get_owner (ValaSymbol* self) {
	ValaScope* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_owner;
	return result;
}


void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value) {
	g_return_if_fail (self != NULL);
	self->priv->_owner = value;
	vala_scope_set_parent_scope (self->priv->_scope, value);
}


const char* vala_symbol_get_name (ValaSymbol* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void vala_symbol_set_name (ValaSymbol* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
}


gboolean vala_symbol_get_active (ValaSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void vala_symbol_set_active (ValaSymbol* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
}


gboolean vala_symbol_get_used (ValaSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_used;
	return result;
}


void vala_symbol_set_used (ValaSymbol* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_used = value;
}


ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self) {
	ValaSymbolAccessibility result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_access;
	return result;
}


void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value) {
	g_return_if_fail (self != NULL);
	self->priv->_access = value;
}


ValaScope* vala_symbol_get_scope (ValaSymbol* self) {
	ValaScope* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_scope;
	return result;
}


gboolean vala_symbol_get_external (ValaSymbol* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_external;
	return result;
}


void vala_symbol_set_external (ValaSymbol* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_external = value;
}


gboolean vala_symbol_get_external_package (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		_tmp0_ = vala_source_file_get_external_package (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void vala_symbol_class_init (ValaSymbolClass * klass) {
	vala_symbol_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_symbol_finalize;
	g_type_class_add_private (klass, sizeof (ValaSymbolPrivate));
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_symbol_real_get_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_symbol_real_get_lower_case_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_symbol_real_get_lower_case_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_symbol_real_get_cheader_filenames;
	VALA_SYMBOL_CLASS (klass)->is_instance_member = vala_symbol_real_is_instance_member;
	VALA_SYMBOL_CLASS (klass)->is_class_member = vala_symbol_real_is_class_member;
}


static void vala_symbol_instance_init (ValaSymbol * self) {
	self->priv = VALA_SYMBOL_GET_PRIVATE (self);
	self->priv->_active = TRUE;
}


static void vala_symbol_finalize (ValaCodeNode* obj) {
	ValaSymbol * self;
	self = VALA_SYMBOL (obj);
	_g_free0 (self->priv->_name);
	_vala_scope_unref0 (self->priv->_scope);
	VALA_CODE_NODE_CLASS (vala_symbol_parent_class)->finalize (obj);
}


GType vala_symbol_get_type (void) {
	static GType vala_symbol_type_id = 0;
	if (vala_symbol_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbol), 0, (GInstanceInitFunc) vala_symbol_instance_init, NULL };
		vala_symbol_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_symbol_type_id;
}



GType vala_symbol_accessibility_get_type (void) {
	static GType vala_symbol_accessibility_type_id = 0;
	if (G_UNLIKELY (vala_symbol_accessibility_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_SYMBOL_ACCESSIBILITY_PRIVATE, "VALA_SYMBOL_ACCESSIBILITY_PRIVATE", "private"}, {VALA_SYMBOL_ACCESSIBILITY_INTERNAL, "VALA_SYMBOL_ACCESSIBILITY_INTERNAL", "internal"}, {VALA_SYMBOL_ACCESSIBILITY_PROTECTED, "VALA_SYMBOL_ACCESSIBILITY_PROTECTED", "protected"}, {VALA_SYMBOL_ACCESSIBILITY_PUBLIC, "VALA_SYMBOL_ACCESSIBILITY_PUBLIC", "public"}, {0, NULL, NULL}};
		vala_symbol_accessibility_type_id = g_enum_register_static ("ValaSymbolAccessibility", values);
	}
	return vala_symbol_accessibility_type_id;
}




