#include "UserAgentChanger.h"
#include <QFile>
#include <QTextStream>

QString UserAgentChanger::getCurrentAgent()
{
    QFile userjs("/home/user/.mozilla/microb/user.js");
    userjs.open(QFile::ReadOnly);

    QTextStream str(&userjs);
    QString uadata = str.readAll();

    if (userjs.error() != QFile::NoError)
    {
        emit error("input/output error");
        return "";
    }
    return uadata.section('\"', 3, 3);
}

void UserAgentChanger::setCurrentAgent(QString agent)
{
    QFile userjs("/home/user/.mozilla/microb/user.js");
    userjs.open(QFile::WriteOnly | QFile::Truncate);

    QTextStream str(&userjs);
    QString uadata = QString("user_pref(\"general.useragent.override\", \"%1\");").arg(agent);
    str << uadata;

    if (userjs.error() != QFile::NoError)
    {
        emit error("input/output error");
        return;
    }
    restartBrowserUI();
    emit writtenOK();
}
