#ifndef SERVICEWINDOW_H
#define SERVICEWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtXml>
#include <QtXmlPatterns>
#include "departurewidget.h"
#include <QtGui>

namespace Ui {
    class ServiceWindow;
}

class ServiceWindow : public QMainWindow
{
    Q_OBJECT
public:
    ServiceWindow(QWidget *parent = 0);
    ~ServiceWindow();

    void sendRequest(); //Send the network request
    void show(QString serviceID);

protected:
    void changeEvent(QEvent *e);

public slots:
    void readResponse(QNetworkReply*); //Read the network response & extract the required data
    void networkError(QNetworkReply::NetworkError);

    void downloadProgress(qint64 rec, qint64 total);
    void uploadProgress(qint64 rec, qint64 total);

    void ensureConnection(); //Used to wait for a network connection
    void cancel(); //Cancel the current request for the departure board

private:
    Ui::ServiceWindow *ui;

    QString serviceID;

    QNetworkAccessManager * manager;
    QNetworkReply * m_reply;

    ServiceWindow * serviceWindow;

    QBuffer received;
    QString from;

    void setupDialog();
    void setupRequest();

    QNetworkRequest request;
    QString requestData;

    inline QString queryOne(QXmlQuery & q, QString query);
    inline QStringList queryList(QXmlQuery & q, QString query);

    QVector<DepartureWidget *> departureWidgets;

    QDialog * dialog; //Dialog with progress bar for the network request
        QLayout * layout;
            QProgressBar * progress;
            QPushButton * cancelButton;

    bool errorFlag;
    bool firstTime;
};

#endif // SERVICEWINDOW_H
