#ifndef FAVOURITESTATIONS_H
#define FAVOURITESTATIONS_H

#include <QDialog>
#include <QSettings>
#include <src/stationchooser.h>

namespace Ui {
    class FavouriteStations;
}

class FavouriteStations : public QDialog {
    Q_OBJECT
public:
    FavouriteStations(QWidget *parent = 0);
    ~FavouriteStations();

    int exec(QString names, QString codes);

public slots:
    void addFavourite(); //When the user clicks the button to add a new favourite station
    void deleteFavourite(); //When the user clicks the delete button

    void accept();
    void reject();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::FavouriteStations *ui;
    QSettings settings;

    QString names; //The QSettings key for the favourite station names
    QString codes; //The QSettings key for the favourite station CRS codes

    void save();
};

#endif // FAVOURITESTATIONS_H
