#include "chooser.h"
#include "ui_chooser.h"

Chooser::Chooser(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Chooser)
{
    ui->setupUi(this);
    ui->scrollArea->setProperty("FingerScrollable", true);
    //Create the buttons for favourite stations
    updateStationButtons();
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

/*
 * Re-creates the display of the buttons for the user's favourite stations.
 */
void Chooser::updateStationButtons()
{
    //Delete all the currently displayed buttons
    for(int i = 0; i < stationButtons.size(); i++)
        delete stationButtons.at(i);

    //Clear the list of pointers to displayed station buttons
    stationButtons.clear();

    //Get the user's favourite stations, and add a button for each
    QStringList favourites = settings.value("FavouriteDepartureBoards", QVariant()).toStringList();
    QStringList favouritesCRS = settings.value("FavouriteDepartureBoardsCRS", QVariant()).toStringList();

    for(int i = 0; i < favourites.size(); i++)
        addStationButton(favourites.at(i), favouritesCRS.at(i));

    //Make a button to allow the user to edit their favourites...
    QPushButton * b = new QPushButton("Edit Favourites...");
    //...add it to the list of displayed buttons & the display widget
    stationButtons.append(b);
    ui->favourites_widget->layout()->addWidget(b);
    b->setIcon(QIcon(":/icons/folder.png"));
    connect(b, SIGNAL(clicked()), this, SLOT(editFavouriteDepartures()));

    QPushButton * b2 = new QPushButton("Choose Station...");
    //...add it to the list of displayed buttons & the display widget
    stationButtons.append(b2);
    ui->favourites_widget->layout()->addWidget(b2);
    connect(b2, SIGNAL(clicked()), this, SLOT(chooseStation()));
}

void Chooser::chooseStation()
{
    StationChooser chooser;

    if(chooser.exec() == QDialog::Accepted)
    {
        departureBoard = new DepartureBoard(this);
        departureBoard->show(chooser.getChoiceCRS());
        departureBoard->setAttribute(Qt::WA_Maemo5StackedWindow);
    }
}

/*
 * Slot to show the dialog allowing the user to edit their favourite stations
 */
void Chooser::editFavouriteDepartures()
{
    favouriteStations.exec("FavouriteDepartureBoards", "FavouriteDepartureBoardsCRS");
    //Update the button display in case the favourites have changed
    updateStationButtons();
}

/*
 * Adds a button to the display widget. Returns a pointer to the created button
 */
QPushButton * Chooser::addStationButton(QString name, QString crs)
{
    QPushButton * b = new QPushButton(name);
    //Create the button and add it to the list of buttons, & the display widget
    stationButtons.append(b);
    ui->favourites_widget->layout()->addWidget(b);
    //Set the button's name to the station's CRS code; we use this in the clicked() slot to find which button was clicked
    b->setObjectName(crs);
    connect(b, SIGNAL(clicked()), this, SLOT(stationSelected()));
    return b;
}

/*
 *  Slot for when one of the station buttons is clicked
 */
void Chooser::stationSelected()
{
    //Show the departure board for the station. The CRS code for the station is found from the button's objectName
    departureBoard = new DepartureBoard(this);
    departureBoard->show(sender()->objectName());
}

Chooser::~Chooser()
{
    if(departureBoard != 0)
        delete departureBoard;

    delete ui;
}

/*
 * Slot to show the journey planner
 */
void Chooser::launchPlanner()
{
    //Launch the webpage for the journey planner online, and quit
    QDesktopServices::openUrl(QUrl("http://ojp.nationalrail.co.uk/en/s/planjourney/query"));
    exit(0);
}

void Chooser::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
