from foursquare import FoursquareSession, Cache

from PySide.QtCore import QSettings, QCoreApplication
from PySide.QtGui import  QApplication, QMessageBox

from main_window import MainWindow
import foursquare_auth
import sys


def start():
    app = QApplication(sys.argv)

    access_token = QSettings().value("access_token")

    if not access_token:
        msgBox = QMessageBox()
        msgBox.setText("Hi! It looks like this is the first run!\n\nI'm going to open a browser window now, and I need you to authorize me so I can get data/do your check-ins, etc.")
        msgBox.setWindowTitle("First run")
        msgBox.addButton("Ok", QMessageBox.AcceptRole)
        msgBox.addButton("Cancel", QMessageBox.RejectRole)
        msgBox.exec_()
        if msgBox.buttonRole(msgBox.clickedButton()) == QMessageBox.AcceptRole:
            foursquare_auth.fetch_code()
            foursquare_auth.fetch_token()
            d = QMessageBox()
            d.setWindowTitle("Image cache")
            d.setText("In order to save bandwidth, category images are cached.  To download these images for a first time, click \"Update image cache\". This'll take some time, but will <b>really</b> speed up searches.")
            d.addButton("Ok", QMessageBox.YesRole)
            d.exec_()

    access_token = QSettings().value("access_token")
    print("code: " + QSettings().value("code"))
    print("access_token: " + QSettings().value("access_token"))

    if access_token:
        session = None

        try:
            session = FoursquareSession(app)
            session.get_user("self", Cache.CacheOrGet)
        except IOError:
            title = "Network Error"
            text = "I couldn't connect to foursquare to retrieve data. Make sure yo're connected to the internet, and try again (keep in mind that it may have been just a network glitch)."
            QMessageBox.warning(None, title, text)
            sys.exit()

        main_window = MainWindow(session)
        main_window.show()

    sys.exit(app.exec_())

if __name__ == '__main__':
    QCoreApplication.setOrganizationName("Ubertech")
    QCoreApplication.setOrganizationDomain("ubertech.com.ar")
    QCoreApplication.setApplicationName("UberSquare")
    start()
