/*
    Copyright 2011 - Tommi Laukkanen (www.substanceofcode.com)

    This file is part of TwimGo.

    NewsFlow is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with NewsFlow. If not, see <http://www.gnu.org/licenses/>.
*/

Qt.include("lib/sha1.js")

String.prototype.startsWith = function(str) {return (this.match("^"+str)==str)}

function XAuth() {

    var normalizedUrl = "";
    var normalizedRequestParameters = "";

    var username = "";
    var password = "";
    var OAUTH_CONSUMER_TOKEN = "ZRutfKnGiKidRYjzfMVoRw";
    var OAUTH_CONSUMER_SECRET = "Er4znNVAR6UzaBXWiI1fCaEYHfh1BxlPdJwLvghdw";
    var HMACSHA1SignatureType = "HMAC-SHA1";

    var OAuthVersion = "1.0";
    var OAuthParameterPrefix = "oauth_";

    var OAuthConsumerKeyKey = "oauth_consumer_key";
    var OAuthCallbackKey = "oauth_callback";
    var OAuthVersionKey = "oauth_version";
    var OAuthSignatureMethodKey = "oauth_signature_method";
    var OAuthSignatureKey = "oauth_signature";
    var OAuthTimestampKey = "oauth_timestamp";
    var OAuthNonceKey = "oauth_nonce";
    var OAuthTokenKey = "oauth_token";
    var OAuthTokenSecretKey = "oauth_token_secret";
    var OAuthVerifier = "oauth_verifier";
    var XAuthUsername = "x_auth_username";
    var XAuthPassword = "x_auth_password";
    var XAuthMode = "x_auth_mode";	

    var token = "";
    var tokenSecret = "";
    var lastURL = "";

    var showError;

    var OAUTH_ACCESS_TOKEN_URL = "https://api.twitter.com/oauth/access_token";

    this.setErrorCallback = function(callback) {
        showError = callback;
    }

    this.setUser = function(user, pass) {
        username = user;
        password = pass;
    }

    this.setTokenAndSecret = function(newToken, newTokenSecret) {
        token = newToken;
        tokenSecret = newTokenSecret;
    }

    this.getLastURL = function() {
        return lastURL;
    }

    function doWebRequest(method, url, callback, errorCallback) {
        lastURL = url;
        var doc = new XMLHttpRequest();
        //console.log("HttpRequest to " + url);
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.HEADERS_RECEIVED) {
                var status = doc.status;
                //console.log("HTTP status on headers " + status);
                if(status!=200) {
                    var shortURL = url;
                    if(shortURL.length>32) {
                        shortURL = shortURL.substring(0,40) + "..";
                    }
                    showError("Twitter API returned " + status + " " + doc.statusText + " on URL " + shortURL);
                    return;
                }
            } else if (doc.readyState == XMLHttpRequest.DONE) {
                var status = doc.status;
                //console.log("HTTP status " + status);
                if(status!=200) {
                    var shortURL = url;
                    if(shortURL.length>40) {
                        shortURL = shortURL.substring(0,40) + "..";
                    }
                    showError("Twitter API returned " + status + " " + doc.statusText + " on URL " + shortURL);
                    return;
                }
                var data = doc.responseText;
                callback(data);
            }
        }
        doc.open(method, url);
        doc.send();
    }

    this.getQueryParameters = function(url) {
        var questionMarkIndex = url.indexOf("?");
        if(questionMarkIndex<0) {
            return new Array();
        }
        var parameters = url.substring(questionMarkIndex+1);
        var params = new Array();
        var para = parameters.split("&");
        for(var i=0; i<para.length; i++) {
            if(para[i].startsWith("oauth")==false) {
                var nameValue = para[i].split("=");
                var q = [nameValue[0], nameValue[1]];
                params.push(q);
            }
        }
        return params;
    }

    this.generateSignatureBase = function(url,consumerKey,token,tokenSecret,xAuthUsername,xAuthPassword,httpMethod,timeStamp,nonce,signatureType) {
        if (typeof(token)=="undefined")
        {
            token = "";
        }
        if (typeof(tokenSecret)=="undefined")
        {
            tokenSecret = "";
        }

        var parameters = this.getQueryParameters(url);
        parameters.push( [OAuthVersionKey, OAuthVersion] );
        parameters.push( [OAuthNonceKey, nonce] );
        parameters.push( [OAuthTimestampKey, timeStamp] );
        parameters.push( [OAuthSignatureMethodKey, signatureType] );
        parameters.push( [OAuthConsumerKeyKey, consumerKey] );

        if (typeof(token)!="undefined" && token != "")
        {
            parameters.push( [OAuthTokenKey, token] );
        } else {
            if ( typeof(xAuthUsername)!="undefined" && xAuthUsername!="")
            {
                parameters.push( [XAuthUsername, this.encode(xAuthUsername)] );
            }

            if ( typeof(xAuthPassword)!="undefined" && xAuthPassword!="")
            {
                parameters.push( [XAuthPassword, this.encode(xAuthPassword)] );
                parameters.push( [XAuthMode, "client_auth"] );
            }
        }

        this.sortParameters( parameters );

        normalizedUrl = this.getSchemeAndHost(url);
        normalizedUrl += this.getAbsolutePath(url);
        normalizedRequestParameters = this.normalizeRequestParameters(parameters);

        var signatureBase = "";
        signatureBase += httpMethod + "&";
        signatureBase += this.encode(normalizedUrl) + "&";
        signatureBase += this.encode(normalizedRequestParameters);

        return signatureBase;
    }

    this.getSchemeAndHost = function(url) {
        var startIndex = url.indexOf("//")+2;
        var endIndex = url.indexOf("/", startIndex);
        return url.substring(0,endIndex);
    }

    this.getAbsolutePath = function(url) {
        var startIndex = url.indexOf("//")+2;
        var endIndex = url.indexOf("/", startIndex);
        var questionMark = url.indexOf("?");
        if(questionMark>0) {
            return url.substring(endIndex, questionMark);
        } else {
            return url.substring(endIndex);
        }
    }

    this.sortParameters = function(items) {
        items.sort();
    }

    this.generateSignature = function(url, consumerKey, consumerSecret,token,tokenSecret,xAuthUsername,xAuthPassword,httpMethod,timeStamp,nonce) {
        var signatureBase = this.generateSignatureBase(
                url,
                consumerKey,
                token,
                tokenSecret,
                xAuthUsername,
                xAuthPassword,
                httpMethod,
                timeStamp,
                nonce,
                HMACSHA1SignatureType);
        var tokenSec = "";
        if(typeof(tokenSecret)!="undefined") {
            tokenSec = tokenSecret;
        }
        var key = this.encode(consumerSecret) + "&" + this.encode(tokenSec);
        var signature = this.getSignature(signatureBase, key);
        return signature;
    }

    this.getSignature = function(message, key)  {
        var b64pad = '=';
        var signature = b64_hmac_sha1(key, message);
        return signature;
    }

    this.normalizeRequestParameters = function( parameters ) {
        var sb = "";
        for(var i in parameters) {
            var par = parameters[i];
            sb += par[0] + "=" + par[1] + "&";
        }
        return sb.substring(0, sb.length-1);
    }

    this.generateTimeStamp = function() {
        //var d = new Date();
        //var utc = Date.UTC(d.getFullYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
        //var t = utc + 0;
        var p = (new Date()).getTime() + 0;
        //console.log("t: " + t);
        //console.log("p: " + p);
        return Math.floor(p / 1000);
    }

    var nonceChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";

    this.generateNonce = function(length) {
        var chars = nonceChars;
        var result = "";
        for (var i = 0; i < length; ++i) {
            var rnum = Math.floor(Math.random() * chars.length);
            result += chars.substring(rnum, rnum+1);
        }
        return result;
    }

    // private String unreservedCharactersPattern = "[a-zA-Z0-9\\-\\._~]";
    // private String unreservedCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~";

    this.encode = function(s) {
        if (typeof(s)=="undefined" || s=="") {
            return "";
        }
        s = encodeURIComponent(s);
        // Now replace the values which encodeURIComponent doesn't do
        // encodeURIComponent ignores: - _ . ! ~ * ' ( )
        // OAuth dictates the only ones you can ignore are: - _ . ~
        // Source: http://developer.mozilla.org/en/docs/Core_JavaScript_1.5_Reference:Global_Functions:encodeURIComponent
        s = s.replace(/\!/g, "%21");
        s = s.replace(/\*/g, "%2A");
        s = s.replace(/\'/g, "%27");
                      s = s.replace(/\(/g, "%28");
                                    s = s.replace(/\)/g, "%29");
                      return s;
    }

                      this.webRequest = function(isPost, url, parameters, callback) {
                          var method = "GET"
                          //Setup postData for signing.
                          //Add the postData to the querystring.
                          var postData = "";
                          if (isPost)
                          {
                              //$("#tweets").append("Handling POST params<br/>");
                              method = "POST";
                          }
                          if (typeof(parameters)!=undefined && parameters!=null && parameters.length>0)
                          {
                              //Decode the parameters and re-encode using the oAuth UrlEncode method.
                              for(var i in parameters) {
                                  var q = parameters[i];
                                  if(postData.length>0) {
                                      postData += "&";
                                  }
                                  postData += q[0] + "=" + this.encode(q[1]);
                              }
                              if (url.indexOf("?") > 0)
                              {
                                  url += "&";
                              }
                              else
                              {
                                  url += "?";
                              }
                              url += postData;
                          }
                          //$("#tweets").append("URL processed<br/>");
                          //}
                          var nonce = this.generateNonce(16);
                          var timeStamp = this.generateTimeStamp();
                          lastURL = timeStamp;

                          //Generate Signature
                          //$("#tweets").append("Generating signature<br/>");
                          var sig = this.generateSignature(
                                  url,
                                  OAUTH_CONSUMER_TOKEN,
                                  OAUTH_CONSUMER_SECRET,
                                  token,
                                  tokenSecret,
                                  username,
                                  password,
                                  method,
                                  timeStamp,
                                  nonce);
                          //$("#tweets").append("Signature created<br/>");

                          var outUrl = normalizedUrl;
                          var querystring = normalizedRequestParameters;
                          if(querystring.length>0) {
                              querystring += "&";
                          }
                          //$("#tweets").append("Adding signature to query string<br/>");
                          querystring += "oauth_signature=" + this.encode(sig);
                          if (querystring.length > 0)
                          {
                              outUrl += "?";
                          }

                          //$("#tweets").append("Doing web request<br/>");
                          doWebRequest(method, outUrl + querystring, callback);
                      }

    }
