/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef KINETICLIST_H
#define KINETICLIST_H

#include <QtGui/QGraphicsLinearLayout>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QGraphicsView>

#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/user.h"
#include "applicationItems/tweet.h"
#include "applicationItems/twitterbutton.h"
#include "account.h"

#ifdef Q_WS_MAEMO_5
    #include <QAbstractKineticScroller>
#endif

class KineticList : public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum Orientation { Horizontal, Vertical };

    KineticList(Orientation orientation, QSizeF size, QGraphicsWidget *parent);
    void removeFromList(int pos);
    void removeFromList(TwitterApplicationItem *item);
    void clearList(void);
    void addToList(TwitterApplicationItem *item, int pos=-1);
    void addToList(TwitterButton *item, int pos=-1);
    void addToList(Tweet *item, int pos=-1);
    void addToList(User *item, int pos=-1);
    void setScrollBarPolicy(Orientation orientation, Qt::ScrollBarPolicy);
    void addMoreButton(void);
    void setSize(QSizeF size);
    void setSelected(int selected);

private slots:
    void _unselect(User* sel);
    void _moreTweets(void);
    void _resizeScene(void);

signals:
    void selected(bool);
    void createTweetInfo(Tweet*);
    void moreTweets(void);

private:
    TwitterButton *_moreButton;
    Orientation _or;
    QGraphicsLinearLayout *_layout;
    QGraphicsProxyWidget *_viewProxy;
    QGraphicsWidget *_list;
    QGraphicsScene *_scene;
    QGraphicsView *_view;
    User* lastSelected;
    int _sel;
};

#endif // KINETICLIST_H
