/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "timelinesettings.h"

TimelineSettings::TimelineSettings(QGraphicsWidget *parent)
    : TwitterApplicationItem(parent),
      _startPos(QPointF(0, 0)),
      _endPos(QPointF(0, 0)),
      _anim(false)
{
    // back button
    _backButton = new TwitterButton(TwitterButton::Back,"",this);
    connect(_backButton, SIGNAL(released()), this, SLOT(_exitAnimation()));

    // line separator
    _sep1 = new QGraphicsLineItem(this);
    _sep1->setPen(QPen(QColor("#0f95da")));

    // Logout Button
    _logoutButton = new TwitterButton(TwitterButton::Generic,"Logout",this);

    // Infos
    _infos = new QGraphicsTextItem(this);

    QString messageHtml = "<p style=\" font-size:18px; padding-bottom:0px; margin-bottom:0px; font-family:'Nokia Sans';\"> ";
    messageHtml += "<span style=\" color:#0f95da ;\">TweeGo Copyright &copy; 2011 v0.6.2 by Mikhail Ramalho</span></p>";
    _infos->setHtml(messageHtml);

    connect(_logoutButton, SIGNAL(released()), SLOT(_logout()));

    // Change Orientation
    _changeOrientation();
    connect(QApplication::desktop(), SIGNAL(resized(int)), SLOT(_changeOrientation()));
}

void TimelineSettings::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    painter->setBrush(QColor(246,253,255));
    painter->setPen(Qt::NoPen);
    painter->setRenderHint(QPainter::Antialiasing);
    painter->drawRoundedRect(0, 60, rect().width(), rect().height()-60, 2, 2);
}

void TimelineSettings::startAnimation(void)
{
    _anim = true;

    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(_startPos);
    mvWhiteRect->setEndValue(_endPos);
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::Linear);
    mvWhiteRect->start();
}

void TimelineSettings::_exitAnimation(void)
{
    _anim = false;

    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(_endPos);
    mvWhiteRect->setEndValue(_startPos);
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::Linear);
    mvWhiteRect->start();
}

void TimelineSettings::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}

void TimelineSettings::_logout()
{
    _exitAnimation();
    emit logout();
}

void TimelineSettings::_changeOrientation(void)
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    resize(screenGeometry.size());

    if(screenGeometry.width() > screenGeometry.height()) {
        _logoutButton->setPos(size().width() - _logoutButton->size().width() - 35, 417);
        _infos->setPos(35, 425);

        _startPos = QPointF(0, 480);

    } else if(screenGeometry.width() < screenGeometry.height()) {
        _logoutButton->setPos((size().width() - _logoutButton->size().width())/2, 733);
        _infos->setPos(35, _logoutButton->pos().y() - _infos->boundingRect().height() - 10);

        _startPos = QPointF(0, 800);
    }

    if(_anim) {
        setPos(_endPos);
    } else {
        setPos(_startPos);
    }

    _sep1->setLine(_infos->pos().x() - 15, _infos->pos().y() - 15, size().width() - 20, _infos->pos().y() - 15);
    _backButton->setPos(size().width() - _backButton->size().width(), 0);
}
