/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "loginsettings.h"

LoginSettings::LoginSettings(QGraphicsWidget *parent)
    : TwitterApplicationItem(parent),
      _startPos(QPointF(0, 0)),
      _endPos(QPointF(0, 0)),
      _anim(false)
{
    // Font
    font.setFamily("Nokia Sans");
    font.setStyle(QFont::StyleNormal);
    font.setStyleStrategy(QFont::PreferAntialias);
    font.setWeight(QFont::Normal);
    font.setPixelSize(18);

    // background
    _bg = new QGraphicsRectItem(this);
    _bg->setBrush(QBrush(QColor(246,253,255)));
    _bg->setPen(Qt::NoPen);

    // Settings Image
    _bgImage = new QGraphicsPixmapItem(QPixmap(":images/resources/settings_login.png"),this);

    // title
    _title = new QGraphicsTextItem("Settings",this);
    _title->setFont(font);
    _title->setDefaultTextColor(QColor("#0f95da"));

    // line 1
    _sep1 = new QGraphicsLineItem(this);
    _sep1->setPen(QPen(QColor("#0f95da")));

    // autologin checkbox and label
    _autologinLabel = new QGraphicsTextItem("Auto-Login",this);
    _autologinLabel->setFont(font);
    _autologinLabel->setDefaultTextColor(QColor("#0f95da"));

    _autologinCheckBox = new TwitterCheckBox(TwitterCheckBox::Settings, false, this);
    connect(_autologinCheckBox,SIGNAL(pressed()),SLOT(_autoLogin()));

    // line 2
    _sep2 = new QGraphicsLineItem(this);
    _sep2->setPen(QPen(QColor("#0f95da")));

    // TODO: proxy checkbox and label

    // Remove account button
    _removeAcc = new TwitterButton(TwitterButton::NewAccount, "Remove Account", this);
    connect(_removeAcc,SIGNAL(released()),SIGNAL(removeAcc()));

    // back button
    _backButton = new TwitterButton(TwitterButton::GenericDownLeft,"Back",this);
    connect(_backButton, SIGNAL(released()), SLOT(_exitAnimation()));

    // Change orientation
    _changeOrientation();
    connect(QApplication::desktop(), SIGNAL(resized(int)), SLOT(_changeOrientation()));
}

void LoginSettings::startAnimation(void)
{
    _loadSettings();
    _anim = true;

    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(_startPos);
    mvWhiteRect->setEndValue(_endPos);
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::OutBack);
    mvWhiteRect->start();
}

void LoginSettings::_exitAnimation(void)
{
    _anim = false;

    QPropertyAnimation *exitAnim = new QPropertyAnimation(this,"pos");
    exitAnim->setStartValue(_endPos);
    exitAnim->setEndValue(_startPos);
    exitAnim->setDuration(250);
    exitAnim->setEasingCurve(QEasingCurve::OutBack);
    exitAnim->start();
}

void LoginSettings::_loadSettings(void)
{
    _autologinCheckBox->setChecked(Account::instance()->isSelectedAutoLogin());

    // TODO: load proxy
}

void LoginSettings::_autoLogin(void)
{
    Account::instance()->setSelectedAutoLogin(_autologinCheckBox->isChecked());
}

void LoginSettings::setSelected(int selected)
{
    _sel = selected;
}

void LoginSettings::_removeUser()
{
    Account::instance()->removeSelected();

    emit accRemoved();
    _exitAnimation();
}

void LoginSettings::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}

void LoginSettings::_changeOrientation(void)
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();

    if(screenGeometry.width() > screenGeometry.height()) {
        _bg->setRect(0, 0, 314, 480);

        _startPos = QPointF(800, 0);
        _endPos = QPointF(486, 0);

        _removeAcc->setPos(23, 353);
    } else if (screenGeometry.width() < screenGeometry.height()) {
        _bg->setRect(0, 0, 480, 500);

        _startPos = QPointF(480, 300);
        _endPos = QPointF(0, 300);

        _removeAcc->setPos(213, 443);
    }
    resize(_bg->rect().size());

    if(_anim) {
        setPos(_endPos);
    } else {
        setPos(_startPos);
    }

    _title->setPos(_bg->x() + 60, 10);
    _sep1->setLine(_bg->x() + 22, 51, _bg->boundingRect().width()-22, 51);
    _autologinLabel->setPos(_sep1->line().x1(), _sep1->line().y1() + 25);
    _autologinCheckBox->setPos(_bg->boundingRect().width() - _autologinCheckBox->boundingRect().width() - 20,
                               _autologinLabel->pos().y());
    _sep2->setLine(_sep1->line().x1(), _sep1->line().y1() + 70, _sep1->line().x2(), _sep1->line().y2() + 70);
    _backButton->setPos(0, _bg->boundingRect().height() - _backButton->boundingRect().height());
}
