/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWEET_H
#define TWEET_H

#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QTextDocument>
#include <QtGui/QPainter>

#include <QtNetwork>

#include "twitterapplicationitem.h"
#include "imagedownload.h"
#include "twitterapi/entry.h"

class Tweet : public TwitterApplicationItem
{
    Q_OBJECT

public:
    Tweet(Entry entry, QGraphicsWidget *parent);

public:
    void setFavorite(bool);
    Entry getEntry(void);
    QImage getImage(void);
    int getPosInList(void);
    bool getFollowing(void);
    void setFollowing(QString, bool);
    QTextDocument* getTweetDocument(void);
    void setPosition(int);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

signals:
    void createTweetInfo(Tweet *tweet);
    void imageDownloaded(void);
    void selected(int);

private slots:
    void _imageReady(QString url);
    void _download(QString url);

private:
    void paint(QPainter *painter,const QStyleOptionGraphicsItem *option, QWidget *widget);
    void createTweetMessage();
    void createAnimations(void);
    QString parseCreatedAt(QDateTime timestamp);
    QString parseSource(QString);
    QString parseText(QString);

private:
    Entry m_entry;
    QImage  m_avatar;
    QGraphicsPixmapItem *m_rtImage;
    QGraphicsPixmapItem *m_favorited;
    bool    paintImage;
    QGraphicsTextItem *message;
};

#endif
