/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "timelinesettings.h"

TimelineSettings::TimelineSettings(QGraphicsWidget *parent)
    : TwitterApplicationItem(parent)
{
    this->setGeometry(0, 0, 800, 480);

    // back button
    _backButton = new TwitterButton(TwitterButton::Back,"",this);
    _backButton->setPos(714, 0);
    connect(_backButton, SIGNAL(released()), this, SLOT(_exitAnimation()));

    // line separator
    _sep1 = new QGraphicsLineItem(20, 403, 780, 403, this);
    _sep1->setPen(QPen(QColor("#0f95da")));

    // Logout Button
    _logoutButton = new TwitterButton(TwitterButton::Generic,"Logout",this);
    _logoutButton->setPos(679,413);

    // Infos
    _infos = new QGraphicsTextItem(this);
    _infos->setPos(20,425);

    QString messageHtml = "<p style=\" font-size:18px; padding-bottom:0px; margin-bottom:0px; font-family:'Nokia Sans';\"> ";
    messageHtml += "<span style=\" color:#0f95da ;\">TweeGo Copyright &copy; 2010 v0.5.1 by Mikhail Ramalho</span></p>";
    _infos->setHtml(messageHtml);

    connect(_logoutButton, SIGNAL(released()), SLOT(_logout()));
}

void TimelineSettings::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    painter->setBrush(QColor(246,253,255));
    painter->setPen(Qt::NoPen);
    painter->setRenderHint(QPainter::Antialiasing);
    painter->drawRoundedRect(0, 60, rect().width(), rect().height()-60, 2, 2);
}

void TimelineSettings::startAnimation(void)
{
    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(QPointF(0,480));
    mvWhiteRect->setEndValue(QPointF(0,0));
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::Linear);
    mvWhiteRect->start();
}

void TimelineSettings::_exitAnimation(void)
{
    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(QPointF(0,0));
    mvWhiteRect->setEndValue(QPointF(0,480));
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::Linear);
    mvWhiteRect->start();
}

void TimelineSettings::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}

void TimelineSettings::_logout()
{
    _exitAnimation();
    emit logout();
}
