/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef BACKEND_H
#define BACKEND_H

#include <QtNetwork>

#include "twitterapi/twitterapi.h"

/*! \namespace Timeline Contains different types of timeline to load.
  */
namespace Timeline
{
    enum TimelineType { Users, Friends, Public };
}

/*! \namespace Connection Contains types of connections.
  */
namespace Connection
{
    enum ConnectionType { VerifyCredentials, Update, GetFriendsTimeline, RemoveStatus,
                          AddFavorite, RemoveFavorite, addFriendship, RemoveFriendship,
                          SendDirectMessage, };
}

/*!
 * \class Backend
 * \brief Handles all operations between the application and the twitlib.
 */
class Backend : public QObject
{
    Q_OBJECT

    public:
        bool isLogin;
        bool cancelNotPressed;
        static Backend *getInstance(void);
        void setFriendsPage(int page);
        void setUsersPage(int page);
        void setMentionsPage(int page);
        void setConsumerKey(const QByteArray &consumerKey);
        void setConsumerSecret(const QByteArray &consumerSecret);
        void setLogin(const QString &login);
        void setPassword(const QString &password);
        void verifyCredentials(void);
        UserInfo userInfo(void);
        EntryList tweets(void);
        void abort(void);

    public slots:
        void update(QString status, QString lat="", QString lon="", quint64 inReplyToStatusId=0);
        void getTimeline(Timeline::TimelineType type);
        void addFavorite(quint64 id);
        void removeFavorite(quint64 id);
        void removeStatus(quint64 id);
        void removeFriendship(quint64 id);
        void addFriendship(quint64 id);
        void sendDirectMessage(QString user, QString msg);
        bool updateProfileImage(QString image);
        void getMentions(void);

    private slots:
        void _parseEntries(EntryList entries);
        void _credentials(EntryList entries);
        void _error(QNetworkReply::NetworkError);
        void _deleteEntry(quint64 id);

    signals:
        void signedOn(void);
        void connectionError(QString);
        void updateError(QString);
        void updatePosted(void);
        void gotFriendsTimeline(void);
        void deletedTweet(quint64);

    private:
        Backend();
        static Backend *_instance;
        TwitterAPI *twitterapi;
        UserInfo userInformations;
        int friendsPage;
        int mentionsPage;
        int userPage;
        EntryList _tweets;
        QList<int> conns;
};

#endif // BACKEND_H
