/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "loginsettings.h"

LoginSettings::LoginSettings(QGraphicsWidget *parent)
    : TwitterApplicationItem(parent)
{
    // Font
    font.setFamily("Nokia Sans");
    font.setStyle(QFont::StyleNormal);
    font.setStyleStrategy(QFont::PreferAntialias);
    font.setWeight(QFont::Normal);
    font.setPixelSize(18);

    // Settings object size
    this->setGeometry(0,0,314,480);

    // background
    _bg = new QGraphicsPixmapItem(QPixmap(":images/resources/settings_login.png"),this);
    _bg->setPos(0,0);

    // title
    _title = new QGraphicsTextItem("Settings",this);
    _title->setPos(_bg->x() + 60,10);
    _title->setFont(font);
    _title->setDefaultTextColor(QColor("#0f95da"));

    // line 1
    _sep1 = new QGraphicsLineItem(_bg->x() + 22,51,this->boundingRect().width()-22,51,this);
    _sep1->setPen(QPen(QColor("#0f95da")));

    // autologin checkbox and label
    QGraphicsTextItem *_autologin = new QGraphicsTextItem("Auto-Login",this);
    _autologin->setPos(_sep1->line().x1(), _sep1->line().y1() + 25);
    _autologin->setFont(font);
    _autologin->setDefaultTextColor(QColor("#0f95da"));

    _autologinCheckBox = new TwitterCheckBox(TwitterCheckBox::Settings, false, this);
    _autologinCheckBox->setPos(_autologin->pos().x() + _autologin->boundingRect().width() + 20, _autologin->pos().y());
    connect(_autologinCheckBox,SIGNAL(pressed()),SLOT(_autoLogin()));

    // line 2
    _sep2 = new QGraphicsLineItem(_sep1->line().x1(), _sep1->line().y1() + 70,
                                  _sep1->line().x2(), _sep1->line().y2() + 70,this);
    _sep2->setPen(QPen(QColor("#0f95da")));

    // proxy checkbox and label

    // back button
    _backButton = new TwitterButton(TwitterButton::GenericDownLeft,"Back",this);
    _backButton->setPos(0,422);
    connect(_backButton, SIGNAL(released()), SLOT(_exitAnimation()));
}

void LoginSettings::startAnimation(void)
{
    _loadSettings();

    QPropertyAnimation *mvWhiteRect = new QPropertyAnimation(this,"pos");
    mvWhiteRect->setStartValue(QPointF(800,0));
    mvWhiteRect->setEndValue(QPointF(800-314,0));
    mvWhiteRect->setDuration(250);
    mvWhiteRect->setEasingCurve(QEasingCurve::OutBack);
    mvWhiteRect->start();
}

void LoginSettings::_exitAnimation(void)
{
    QPropertyAnimation *exitAnim = new QPropertyAnimation(this,"pos");
    exitAnim->setStartValue(QPointF(800-314,0));
    exitAnim->setEndValue(QPointF(800,0));
    exitAnim->setDuration(250);
    exitAnim->setEasingCurve(QEasingCurve::OutBack);
    exitAnim->start();
}

void LoginSettings::_loadSettings(void)
{
    QSettings settings("Zagaia","TweeGo");
    settings.beginGroup("AUTOLOGIN");
    autologin = settings.value("autologin").toBool();
    int sel = settings.value("user").toInt();
    settings.endGroup();

    if (autologin && sel == _sel)
        _autologinCheckBox->setChecked(true);
    else
        _autologinCheckBox->setChecked(false);
}

void LoginSettings::_autoLogin(void)
{
    QSettings settings("Zagaia","TweeGo");
    settings.beginGroup("AUTOLOGIN");

    if(_autologinCheckBox->isChecked())
    {
        settings.setValue("autologin",1);
        settings.setValue("user",_sel);
    } else {
        settings.setValue("autologin",0);
        settings.setValue("user",-1);
    }

    settings.endGroup();
}

void LoginSettings::setSelected(int selected)
{
    _sel = selected;
}

void LoginSettings::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    Q_UNUSED(event);
}
