/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITPIC_H
#define TWITPIC_H

#include <QDebug>
#include <QNetworkAccessManager>
#include <QNetworkProxy>
#include <QStringList>
#include <QListIterator>
#include <QRegExp>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QtGui/QPainter>
#include <QWebFrame>
#include <QGraphicsSceneMouseEvent>
#include <QFileDialog>
#include <QMessageBox>
#include <QtXml/QDomDocument>
#include <QtXml/QDomElement>
#include <QtXml/QDomNodeList>

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

#include "applicationItems/twitterapplicationitem.h"

/*!
 * \class TwitPic
 *
 * \brief TwitPic class handles all operations related to TwitPic.
 */
class TwitPic: public TwitterApplicationItem
{
    Q_OBJECT

    public:
        enum Services { twitPic, tweetPhoto };

        TwitPic(QGraphicsWidget *parent = 0);
        ~TwitPic();
        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
        void downloadTwitPic(QString Url);
        void downloadTweetPhoto(QString Url);

    signals:
        void errorMessage( const QString &message );
        void urlDownloaded(QString imageUrl);
        void animExit(void);

    protected:
        virtual void mousePressEvent(QGraphicsSceneMouseEvent *);
        virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *);

    private slots:
        void handleTwitPicRequest(QNetworkReply *reply);
        void handleTweetPhotoRequest(QNetworkReply *reply);

    private:
        void parseHtml(QString html);
        void parseTweetPhotoXml(QString xml);
        void downloadImage(QString imageUrl);

    private:
        QNetworkAccessManager *m_twitPicManager;
        QNetworkAccessManager *m_tweetPhotoManager;
        QImage m_image;
        QImage m_imageScaled;
        bool m_isImage;
        bool m_paintImage;
        bool m_isTweetPhoto;
        QStringList m_imageUrlList;
        QString m_message;
};

#endif // TWITPIC_H
