/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERTOPBAR_H
#define TWITTERTOPBAR_H

#include <QtCore/QObject>
#include <QtCore/QRectF>
#include <QtCore/QString>

#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtNetwork>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>
#include <QtGui/QPainterPath>
#include <QtGui/QFileDialog>

#include "twitterapplicationitem.h"
#include "backend.h"

/*! \class TwitterTopBar
 * \brief TwitterTopBar class
 * Handles all operations related to the topbar.
 */
class TwitterTopBar : public TwitterApplicationItem
{
    Q_OBJECT

public:
    TwitterTopBar(QGraphicsWidget *parent);
    ~TwitterTopBar(void);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    QString getUsername();

private slots:
    void _handleNetworkRequest(QNetworkReply *reply);
    void _download(QString Url);
    void _labelPositions(void);

signals:
    void finished(void);
    void changeAvatar(QString);

private:
    QNetworkAccessManager m_manager;
    QStringList list;
    QList<QPointF> listPositions;
    QImage m_image;
    QString followingNameText;
    QString followingText;
    QString followersNameText;
    QString followersText;
    QString tweetsNameText;
    QString tweetsText;
    bool paintImage;
    bool createTimeline;

public slots:
    void updateTopBar(bool timeline);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
};
#endif // TWITTERTOPBAR_H
