/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TIMELINEVIEW_H
#define TIMELINEVIEW_H

#include <QtCore/QAbstractAnimation>
#include <QtCore/QEasingCurve>
#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QParallelAnimationGroup>
#include <QtCore/QPointF>
#include <QtCore/QPropertyAnimation>
#include <QtCore/QRectF>
#include <QtCore/QRegExp>
#include <QtCore/QSequentialAnimationGroup>
#include <QtCore/QString>
#include <QtCore/QStringList>

#include <QtGui/QFont>
#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QGraphicsRectItem>
#include <QtGui/QGraphicsTextItem>

#include <QtDBus>

#include "backend.h"
#include "applicationItems/lineedit.h"
#include "applicationItems/loader.h"
#include "applicationItems/twitterapplicationitem.h"
#include "applicationItems/twitterbutton.h"
#include "applicationItems/twittercheckbox.h"
#include "applicationItems/twittertimeline.h"
#include "applicationItems/twittertopbar.h"
#include "applicationItems/twittertweetinfo.h"
#include "urlshortener.h"
#include "getlocation.h"
#include "mapzoom.h"

/*!
 * \class TimelineView
 *
 * \brief Timeline window with customized widgets.
 */
class TimelineView : public QGraphicsWidget
{
    Q_OBJECT

public:
    TimelineView(void);
    ~TimelineView();  
    void createUi(void);
    void setUpdateMessage(const QString &message);
    void updateLabels(void);
    void updateTopBar(void);
    int containsUrl(QString message);
    QString getUpdateMessage(void);
    TwitterButton *_logoutButton;
    TwitterButton *_backButton;
    TwitterButton *_refreshButton;
    TwitterButton *_moreTweetsButton;
    TwitterCheckBox *_locationCheckBox;

public slots:
    void connectionError(void);
    void urlShorteningError(QString);
    void endLoader(void);
    void startLoader(void);
    void createTimeline(void);
    void getCoordinates(void);

signals:
    void postUpdate(void);
    void showTimeline(void);
    void shorteningError(QString);
    void retweet(void);
    void reply(void);
    void favorite(QString);
    void deleteTweet(void);
    void logout(void);
    void moveTimeline(void);
    void back(void);
    void unfollow(void);
    void refresh(void);
    void done(void);
    void moreTweets(void);
    void coordinatesOk(void);
    void changeAvatar(QString);

private slots:
    void _emitMoreTweets(void);
    void _changeCounter(int);
    void _deleteLoader(void);
    void _emitPostUpdate(void);
    void _exitAnimationFinished(void);
    void _hasTimeline(void);
    void _handleNewMessage(QString newMessage);
    void _emitExposeSignal(void);
    void _createTweetInfo(void);
    void _backToLogin(void);
    void _emitUnfollow(void);
    void _emitDelete(void);
    void _emitFavorite(QString);
    void _emitRefresh(void);
    void _emitChangeAvatar(QString);

private:
    QAbstractAnimation *_createEntryAnimation(void);
    QAbstractAnimation *_createExitAnimation();
    void _createEntry(void);
    void _createButtons(void);
    void _createLabels(void);
    void _createTopBar(void);
    void _addOpacityAnim(QParallelAnimationGroup *anim,
                         TwitterApplicationItem *item,
                         int delay);
    void _addPosAnim(QParallelAnimationGroup *anim,
                     TwitterApplicationItem *item,
                     QPointF startValue, QPointF endValue,
                     QEasingCurve easing, int delay);

private:
    QAbstractAnimation *_exitAnim;
    QAbstractAnimation *_entryAnim;
    QGraphicsTextItem *_labelUpdateCounter;
    QGraphicsRectItem *_background;
    TwitterButton *_exposeButton;
    Loader *_loader;
    LineEdit *_entryUpdate;
    TwitterApplicationItem *_image;

public:
    TwitterTopBar *_topBar;
    TwitterTimeline *_timeline;
    TwitterTweetInfo *_tweetInfo;
    TwitterButton *_updateButton;
    QList<QPointF> labelPos;
    UrlShortener *_urlShortener;
    IpLocation *_coordinates;
    QString number;
    GMaps *map;
};

#endif // TIMELINEVIEW_H
