/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef DIALOG_H
#define DIALOG_H

#include <QtGui/QGraphicsLayout>
#include <QtGui/QGraphicsWidget>
#include <QtGui/QMessageBox>
#include <QtGui/QPainter>
#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QWidget>

#include <QtCore/QAbstractAnimation>
#include <QtCore/QObject>
#include <QtCore/QEventLoop>
#include <QtCore/QPropertyAnimation>
#include <QtCore/QRectF>
#include <QtCore/QString>
#include <QtCore/QVariantAnimation>

#include "twitterapplicationitem.h"
#include "twitterbutton.h"

/*!
 * \class DialogView
 *
 * \brief Dialog View class
 *
 * Handles dialog view windows.
 */
class DialogView : public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum Type { Warning, Error };

    DialogView(DialogView::Type type, QGraphicsWidget *parent = 0);
    ~DialogView();
    void exec();
    void setTitle(const QString &title);
    void setMessage(const QString &message);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

signals:
    void yesPressed(void);
    void noPressed(void);

public slots:
    int exit(void);
    void buttonPressed();

private:
    Type _type;
    QString _title;
    QString _message;
    QEventLoop _eventLoop;
    TwitterButton *_okButton;
    TwitterButton *_yesButton;
    TwitterButton *_noButton;
};

#endif
