/*
 * vim:ts=4:sw=4:et:cindent:cino=(0
 */ 

#include <stdlib.h>
#include <glib.h>

#define FILENAME MCE

typedef struct _value_t
{
    const gchar *group;
    const gchar *name;
    const gchar *value;
} value_t;

int main (int argc, char *argv[])
{
    GKeyFile *kf;
    value_t v[3];
    gint i;
    gchar *lens_cover;
    GError *error = NULL;
    gchar *data;
    gsize size;

    if (argc < (sizeof (v) / sizeof (value_t)) + 1)
    {
        exit (EXIT_FAILURE);
    }

    v[0].group = "PowerKey";
    v[0].name = "PowerKeyShortAction";
    v[0].value = argv[1];

    v[1].group = "PowerKey";
    v[1].name = "PowerKeyLongAction";
    v[1].value = argv[2];

    v[2].group = "PowerKey";
    v[2].name = "PowerKeyDoubleAction";
    v[2].value = argv[3];

    lens_cover = argv[4];

    kf = g_key_file_new ();
    if (!g_key_file_load_from_file (kf, FILENAME,
                                    G_KEY_FILE_KEEP_COMMENTS |
                                    G_KEY_FILE_KEEP_TRANSLATIONS,
                                    &error))
    {
        g_warning ("Error while reading %s: %s", FILENAME, error->message);
        g_error_free (error);
        exit (EXIT_FAILURE);
    }

    for (i = 0; i < sizeof (v) / sizeof (value_t); i++)
    {
        g_key_file_set_string (kf, v[i].group, v[i].name, v[i].value);
    }

    g_key_file_set_string (kf, "TKLock", "LensCoverUnlock", lens_cover);

    data = g_key_file_to_data (kf, &size, &error);
    if (data == NULL)
    {
        g_warning ("Error while writing keyfile data.");
        g_error_free (error);
        exit (EXIT_FAILURE);
    }
    
    if (!g_file_set_contents (FILENAME, data, size, &error))
    {
        g_warning ("Error writing %s", FILENAME);
        g_free (data);
        g_error_free (error);
        exit (EXIT_FAILURE);
    }

    g_free (data);
    g_key_file_free (kf);

    exit (EXIT_SUCCESS);
}

