/*
 * vim:ts=4:sw=4:et:cindent:cino=(0
 */ 

#ifndef __TWEAKR_SECTION_H__
#define __TWEAKR_SECTION_H__

#include <glib-object.h>

G_BEGIN_DECLS


#define TWEAKR_TYPE_SECTION \
        (tweakr_section_get_type ())
#define TWEAKR_SECTION(o) \
        (G_TYPE_CHECK_INSTANCE_CAST ((o), TWEAKR_TYPE_SECTION, \
        TweakrSection))
#define TWEAKR_SECTION_CLASS(k) \
        (G_TYPE_CHECK_CLASS_CAST((k), TWEAKR_TYPE_SECTION, \
        TweakrSectionClass))
#define TWEAKR_IS_SECTION(o) \
        (G_TYPE_CHECK_INSTANCE_TYPE ((o), TWEAKR_TYPE_SECTION))
#define TWEAKR_IS_SECTION_CLASS(k) \
        (G_TYPE_CHECK_CLASS_TYPE ((k), TWEAKR_TYPE_SECTION))
#define TWEAKR_SECTION_GET_CLASS(o) \
        (G_TYPE_INSTANCE_GET_CLASS ((o), TWEAKR_TYPE_SECTION, \
        TweakrSectionClass))


typedef struct _TweakrSection      TweakrSection;
typedef struct _TweakrSectionClass TweakrSectionClass;

struct _TweakrSection
{
    GObject  parent_instance;

    /* The widget that the section populates (usually a vbox */
    GtkWidget *widget;
    const gchar *name;
};

struct _TweakrSectionClass
{
    GObjectClass  parent_class;

    const gchar *name;

    gboolean (*save) (TweakrSection *section,
                      gboolean *requires_restart);
};


GType tweakr_section_get_type (void) G_GNUC_CONST;

TweakrSection * tweakr_section_new (GType type);

GtkWidget * tweakr_section_get_widget (TweakrSection *section);
gboolean tweakr_section_save (TweakrSection *section,
                                    gboolean *requires_restart);

G_END_DECLS

#endif /* __TWEAKR_SECTION_H_ */

