#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QFile>
#include <QSettings>

#define PLUGINPATH "/usr/lib/browser/plugins/libflashplayer.so"
#ifdef Q_WS_MAEMO5
    #ifdef QT_VERSION >= 0x040700
#define PLUGINBACKPUPPATH_LEGACY "/home/user/MyDocs/libflashplayer.so.pr1.3"
#define PLUGINBACKPUPPATH "/home/user/MyDocs/libflashplayer.so.pr13.tweakflashver"
#define PLUGINSIZE 6732516
#define OFFSET1 0x5B61FC
#define OFFSET2 0x5CCC30
#define PART1ORIG "9.0 r277"
#define PART1LEN 8
#define DIGITS 5
#define PART2ORIG "LNX 9,0,277,0"
#define PART2LEN 13
    #else
#define PLUGINBACKPUPPATH_LEGACY "/home/user/MyDocs/libflashplayer.so.pr1.2"
#define PLUGINBACKPUPPATH "/home/user/MyDocs/libflashplayer.so.pr12.tweakflashver"
#define PLUGINSIZE 6723876
#define OFFSET1 0x5B3D24
#define OFFSET2 0x5CA71C
#define PART1ORIG "9.0 r260"
#define PART1LEN 8
#define DIGITS 5
#define PART2ORIG "LNX 9,0,260,0"
#define PART2LEN 13
    #endif
#else
#define PLUGINBACKPUPPATH_LEGACY "/home/user/MyDocs/libflashplayer.so.orig"
#define PLUGINBACKPUPPATH "/home/user/MyDocs/libflashplayer.so.tweakflashver"
#define PLUGINSIZE 5459364
#define OFFSET1 0x48F5D8
#define OFFSET2 0x499010
#define PART1ORIG "9.0 r48"
#define PART1LEN 7
#define DIGITS 4
#define PART2ORIG "LNX 9,0,48,0"
#define PART2LEN 12
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void enableAutoRotate();    // cludge

private slots:
    void on_actionRestore_plugin_to_factory_state_triggered();
    void on_actionAbout_triggered();
    void on_actionAbout_Qt_triggered();
    void on_actionWhy_triggered();
    void setManualMode(bool b); //! Use combobox or edit fields for version
    void updateFields();        //! change edit fields according to combo box content
    void changeVer();           //! Apply changes

private:
    Ui::MainWindow *ui;
    QSettings* settings;   //! app config
    QFile plugin;         //! the actual binary
    void loadFlashVers(); //! Load available premade versions from the config file
    void readFlashVer();  //! Load version from binary
};

#endif // MAINWINDOW_H
