#!/usr/bin/python
import sys
import os
import subprocess
from PyQt4 import QtGui,QtCore,QtMaemo5
from tvcplayer_ui import *
from tvcplayer_rec import *
from tvcplayer_acc import *
from tvcplayer_opt import *
from tvcplayer_about import *

catchupdir="/home/user/.tvcplayer"

class AboutDialog(QtGui.QDialog):
	def __init__(self, parent=None):
                QtGui.QWidget.__init__(self, parent)
                self.ui = Ui_dialog_About()
                self.ui.setupUi(self)

class OptDialog(QtGui.QDialog):
	def __init__(self, parent=None):
                QtGui.QWidget.__init__(self, parent)
                self.ui = Ui_dialog_Options()
                self.ui.setupUi(self)
                try:
                        f=open(catchupdir+"/mplayeropts","r")
                except IOError:
			f=open("/opt/tvcplayer/mplayeropts","r")

                opts=f.read()
	        f.close()

		self.ui.line_Options.setText(opts)
		self.ui.line_Options.home(False)

                QtCore.QObject.connect(self.ui.btn_OptOK,
QtCore.SIGNAL('clicked()'), self.doOK)
                QtCore.QObject.connect(self.ui.btn_Reset,
QtCore.SIGNAL('clicked()'), self.doReset)

	def doOK(self):
                opts = self.ui.line_Options.text()
                f = open(catchupdir+"/mplayeropts","w")
                f.write(str(opts))
                f.close()
		self.accept()

	def doReset(self):		                        
		f=open("/opt/tvcplayer/mplayeropts","r")
                opts=f.read()
                f.close()
		self.ui.line_Options.setText(opts)
		self.ui.line_Options.home(False)



class AccDialog(QtGui.QDialog):
        def __init__(self, parent=None):
                QtGui.QWidget.__init__(self, parent)
                self.ui = Ui_dialog_Account()
                self.ui.setupUi(self)
		try:
			f=open(catchupdir+"/username","r")
		except IOError:
			username=""
		else:
	                username=f.read()
        	        f.close()

		try:
	                f=open(catchupdir+"/password","r")
		except IOError:
			password=""
		else:
	                password=f.read()
        	        f.close()

		self.ui.line_Username.setText(username)
		self.ui.line_Password.setText(password)

                QtCore.QObject.connect(self.ui.line_Username,
QtCore.SIGNAL('editingFinished()'), self.doUsername)
                QtCore.QObject.connect(self.ui.line_Password,
QtCore.SIGNAL('editingFinished()'), self.doPassword)
		QtCore.QObject.connect(self.ui.btn_Signup,
QtCore.SIGNAL('clicked()'), self.doSignup)
		QtCore.QObject.connect(self.ui.btn_AccOK,
QtCore.SIGNAL('clicked()'), self.doOK)

	def doUsername(self):
		username = self.ui.line_Username.text()
		f = open(catchupdir+"/username","w")
		f.write(str(username))
		f.close()

        def doPassword(self):
                password = self.ui.line_Password.text()
                f = open(catchupdir+"/password","w")
                f.write(str(password))
                f.close()

        def doSignup(self):
                QtGui.QDesktopServices().openUrl(QtCore.QUrl("http://signup.tvcatchup.com",QtCore.QUrl.TolerantMode))


	def doOK(self):
		self.accept()


class RecDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QWidget.__init__(self, parent)
		QtCore.QDateTime.__init__(self)
		self.ui = Ui_dialog_Record()
		self.ui.setupUi(self)
                try:
                        f=open(catchupdir+"/outfile","r")
                except IOError:
                        outfile="/home/user/MyDocs/rec.ts"
			f=open(catchupdir+"/outfile","w")
			f.write(str(outfile))
			f.close()
                else:
                        outfile=f.read()
                        f.close()
 		self.ui.line_Time.setText("15")
 		self.ui.line_Outfile.setText(outfile)
		self.ui.radioNow.setChecked(1)
		self.ui.dateTimeEdit.setDisabled(1)
		cdt = QtCore.QDateTime.currentDateTime()
		ct = cdt.time()
		ct.setHMS(ct.hour(),0,0)
		cdt.setTime(ct)
		cdt=cdt.addSecs(3600)
		self.ui.dateTimeEdit.setDateTime(cdt)

          	QtCore.QObject.connect(self.ui.btn_Filedialog, 
QtCore.SIGNAL('clicked()'), self.doFiledialog)
                QtCore.QObject.connect(self.ui.line_Outfile,
QtCore.SIGNAL('editingFinished()'), self.doOutfile)
		QtCore.QObject.connect(self.ui.btn_Start,
QtCore.SIGNAL('clicked()'), self.doStart)
		QtCore.QObject.connect(self.ui.radioNow,
QtCore.SIGNAL('clicked()'), self.doNow)
		QtCore.QObject.connect(self.ui.radioTime,
QtCore.SIGNAL('clicked()'), self.doNow)
		
	def doNow(self):
		if (self.ui.radioNow.isChecked()==1):
			self.ui.dateTimeEdit.setDisabled(1)
		else:
			self.ui.dateTimeEdit.setEnabled(1)

	def doFiledialog(self):
                outfile = self.ui.line_Outfile.text()
		newoutfile = QtGui.QFileDialog.getSaveFileName(self,
			"Select output file for recording",
			outfile,"Video file (*.ts)")
		print newoutfile
		if newoutfile == '':
			return
		else:
			self.ui.line_Outfile.setText(newoutfile)
		self.doOutfile()

	def doOutfile(self):
		outfile = self.ui.line_Outfile.text()
                f=open(catchupdir+"/outfile","w")
                f.write(str(outfile))
                f.close()

	def doStart(self):
                channelitem=myapp.ui.list_Channel.selectedItems()
                myapp.ui.list_Channel.setCurrentItem(channelitem[0])
 		channel = myapp.ui.list_Channel.currentRow() + 1
		time = self.ui.line_Time.text()

                try:
                        f=open(catchupdir+"/outfile","r")
                except IOError:
                        return
                else:
                        outfile=f.read()
                        f.close()

                try:
                        f=open(catchupdir+"/username","r")
                except IOError:
                        return
                else:
                        username=f.read()
                        f.close()

                try:
                        f=open(catchupdir+"/password","r+")

                except IOError:
                        return
                else:
                        password=f.read()
                        f.close()

		cmdline = '/bin/sh /opt/tvcplayer/tvcplayer.sh ' + str(channel)
		print "Record",channel
		cmdline=cmdline + ' ' + outfile + ' ' + time
		print cmdline
		self.accept()
		if (self.ui.radioNow.isChecked()==1):
			os.system('/usr/bin/osso-xterm "'+str(cmdline)+'"')
		else:
			qdt = self.ui.dateTimeEdit.dateTime()
			sdt=qdt.toString("hh:mm:ss dd MMM")
			cmdline = '/usr/bin/python /opt/alarmed/alarmed.py -C -T "TVCPlayer Recording" -z "'+str(sdt)+'" -E "/usr/bin/osso-xterm \\"'+str(cmdline)+'\\""'
			print 'Running '+cmdline
			op = subprocess.Popen(cmdline,stdout=subprocess.PIPE,shell=True).communicate()[0]
			if ( op.split(".")[0] == "Event added successfully" ):
				QtMaemo5.QMaemo5InformationBox.information(myapp, "Recording scheduled -- Use Alarmed to manage\n"+op)
			else:
				QtMaemo5.QMaemo5InformationBox.information(myapp, "Scheduling failed:\n"+op)
	





class MyForm(QtGui.QMainWindow):
        def __init__(self, parent=None):
                #build parent user interface
                QtGui.QWidget.__init__(self, parent)
                self.ui = Ui_MainWindow()
                self.ui.setupUi(self)
		self.ui.list_Channel.setCurrentRow(0)

		QtCore.QObject.connect(self.ui.btn_Watch,
QtCore.SIGNAL('clicked()'), self.doWatch)
          	QtCore.QObject.connect(self.ui.btn_Record, 
QtCore.SIGNAL('clicked()'), self.doRecord)
		QtCore.QObject.connect(self.ui.action_AccountDetails, 
QtCore.SIGNAL('triggered()'), self.doAcc)
                QtCore.QObject.connect(self.ui.action_Options,
QtCore.SIGNAL('triggered()'), self.doOpt)
                QtCore.QObject.connect(self.ui.actionAbout,
QtCore.SIGNAL('triggered()'), self.doAbout)
		QtCore.QObject.connect(self.ui.btn_Listings, 
QtCore.SIGNAL('clicked()'), self.doListings)

	def doRecord(self):
                try:
                        f=open(catchupdir+"/username","r")
                except IOError:
                        username=""
                else:
                        username=f.read()
                        f.close()

                try:
                        f=open(catchupdir+"/password","r+")

                except IOError:
                        password=""
                else:
                        password=f.read()
                        f.close()
		if username=="" or password=="":
			if AccDialog.exec_(AccDialog(self)) == 0:
				print "Cancelled"
				return

		result = RecDialog.exec_(RecDialog(self))	

	def doAbout(self):
		result = AboutDialog.exec_(AboutDialog(self))

	def doAcc(self):
		result = AccDialog.exec_(AccDialog(self))

	def doOpt(self):
		result = OptDialog.exec_(OptDialog(self))


	def doWatch(self):
		channelitem=self.ui.list_Channel.selectedItems()
		self.ui.list_Channel.setCurrentItem(channelitem[0])
 		channel = self.ui.list_Channel.currentRow() + 1
                try:
                        f=open(catchupdir+"/username","r")
                except IOError:
                        username=""
                else:
                        username=f.read()
                        f.close()

                try:
                        f=open(catchupdir+"/password","r+")
                except IOError:
                        password=""
                else:
                        password=f.read()
                        f.close()

                if username=="" or password=="":
                        if AccDialog.exec_(AccDialog(self)) == 0:
                                print "Cancelled"
                                return

		cmdline = '/bin/sh /opt/tvcplayer/tvcplayer.sh ' + str(channel)
		print "Watch",channel
		print cmdline
		os.system('/usr/bin/osso-xterm "'+str(cmdline)+'"')

	def doListings(self):
		QtGui.QDesktopServices().openUrl(QtCore.QUrl("http://www.tvcatchup.com/guide.html",QtCore.QUrl.TolerantMode))

if __name__ == "__main__":
        app = QtGui.QApplication(sys.argv)
        myapp = MyForm()
        myapp.show()
        sys.exit(app.exec_())
