import Qt 4.7
import "OAuth.js" as OAuthLogic

Item { 
	id: wrapper
    property variant model: xmlModel
    property string tags : ""
    property string credentials: ""
	//三种： everyone,self,user
    property string mode : "self"
    property int status: -1
    function reload() {
		//console.log("mode="+mode);
		status=0;
        var url = '';
		var params;
        if(mode == 'self') //自己的好友最近发了什么
            url = 'http://api.t.sina.com.cn/statuses/friends_timeline.json'
        else if(mode == 'user') {//查看指定用户的发言
			if(tags==null) {
				console.log("tags cannot be null");
				return ;
			} 
			url = 'http://api.t.sina.com.cn/statuses/user_timeline.json'
			params=[["user_id",tags]];
		}
        else //所有人的
            url = 'http://api.t.sina.com.cn/statuses/public_timeline.json'
        var xhr ;
		xhr= OAuthLogic.createOAuthHeader("GET", url, undefined, {"token":oauth.token, "secret":oauth.secret},params);
        
        xhr.onreadystatechange = function() { 
            if (xhr.readyState == XMLHttpRequest.DONE) {
                var a = JSON.parse(xhr.responseText);
				mainView.visible=false;
				xmlModel.clear();
				
				//console.log("load data completed. "+a.length+" records");
                for (var b in a) {
                    var o = a[b];
					//console.log(o) 
					if(o.user!=null && o.user.profile_image_url!=null){
						//console.log(o.user.profile_image_url) 
						xmlModel.append(o);
					}
                }
				mainView.visible=true;
				status=1;
				//console.log("load completed.mode="+mode);
            }
        }
        xhr.send();
    }
	
	ListModel  {
		id: xmlModel
	}
	
}
