import Qt 4.7
import "TSinaCore" 1.0 as TSina

Item {
    id: screen; width: 800; height: 480
	//false,鿴Լtrue,鿴
    property bool userView : false
    property variant tmpStr
    function setMode(m){
        screen.userView = m!='self';
        if(userView == false){
            toolBar.button2Label = "View others";
        } else {			
            toolBar.button2Label = "Return home";			
        }
		rssModel.mode=m;
		rssModel.reload();
    }
	//@param str user_id to query
    function setUser(str){
		console.log('set user_id='+str);
		rssModel.tags = str;
	}


    //TODO: better way to return to the auth screen
    Keys.onEscapePressed: rssModel.credentials=''
    Rectangle {
        id: background
        anchors.fill: parent; color: "#343434";

        Image { source: "TSinaCore/images/stripes.png"; fillMode: Image.Tile; anchors.fill: parent; opacity: 0.3 }

        MouseArea {
            anchors.fill: parent
            onClicked: screen.focus = false;
        }

        TSina.OAuth{
        id: oauth
        onAuthenticationCompleted: {
            screen.focus = true;
            rssModel.credentials = 'yes'
			titleBar.reload(oauth.user_id);
            rssModel.reload();
        }
		
		onAuthenticationFail: {
            rssModel.status=3;
        }
        }
        TSina.RssModel { id: rssModel }
        TSina.Loading { anchors.centerIn: parent; visible: rssModel.status==0 && state!='unauthed'}
        Text {
            width: 180
            text: "Could not access TSina using this screen name and password pair.";
            color: "#cccccc"; style: Text.Raised; styleColor: "black"; wrapMode: Text.WordWrap
            visible: rssModel.status==3; anchors.centerIn: parent
        }

        Item {
            id: views
            x: 2; width: parent.width - 4
            y:60 //Below the title bars
            height: 380

            TSina.AuthView{
                id: authView
                anchors.verticalCenter: parent.verticalCenter
                width: parent.width; height: parent.height-60;
                x: -(screen.width * 1.5)
            }

            TSina.FatDelegate { id: fatDelegate }
            ListView {
                id: mainView; model: rssModel.model; delegate: fatDelegate;
                width: parent.width; height: parent.height; x: 0; cacheBuffer: 100;
            }
        }

        TSina.MultiTitleBar { id: titleBar; width: parent.width }
        TSina.ToolBar { id: toolBar; height: 40;
            //anchors.bottom: parent.bottom;
            //TODO: Use anchor changes instead of hard coding
            y: screen.height - 40
            width: parent.width; opacity: 0.9
            button1Label: "Update"
            button2Label: "View others"
            onButton1Clicked: rssModel.reload();
            onButton2Clicked:
            {
                if(screen.userView == false){
                    screen.setMode('everyone');
                }else{
                    rssModel.tags='';
                    screen.setMode('self');
                }
            }
        }

        states: [
            State {
                name: "unauthed"; when: oauth.user_id==""
                PropertyChanges { target: authView; x: 0 }
                PropertyChanges { target: mainView; x: -(parent.width * 1.5) }
                PropertyChanges { target: titleBar; y: -80 }
                PropertyChanges { target: toolBar; y: screen.height }
            }
        ]
        transitions: [
            Transition { NumberAnimation { properties: "x,y"; duration: 500; easing.type: Easing.InOutQuad } }
        ]
    }
}
