#include <QApplication>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <QFile>
#include <iostream>

int main(int argc, char *argv[]){
     QApplication app(argc, argv);

     QDeclarativeView view;
     QDeclarativeContext *context = view.rootContext();
     const char* files[]={MYDATADIR"/tsina.qml","tsina.qml",NULL};
     const char* mainfile=NULL;
     for(const char** f=&files[0];*f!=NULL;++f){
	QFile file(*f);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
	 std::cout<<*f<<" not found"<<std::endl;
         continue;
	}
	file.close();
	mainfile=*f;
	break;
     }
     if(mainfile==NULL) {
        std::cerr<<"cannot found qml file"<<std::endl;
	return 0;
     }
     std::cout<<"loading data from "<<mainfile<<std::endl;
     view.setSource(QUrl::fromLocalFile(mainfile));
     view.show();

     return app.exec();
 }
