# -*- coding: utf-8 -*-
from common import CustomWindow, IconCache
from gravatar import QGravatar
from PyQt4.QtGui import QGridLayout, QLabel, QPushButton, QScrollArea,\
    QWidget, QAction, QVBoxLayout, QSizePolicy, QToolButton, QListView
from PyQt4.QtCore import QSignalMapper, QString, QSize, QAbstractListModel, QModelIndex
from PyQt4.Qt import Qt
from config import config
from projects.view import ProjectsView
from gettextfile.view import FileView
from views.login import LoginDialog
from servers.model import TransifexLoginFailed
from bookmarks.model import BookmarkListModel

from PyQt4.QtGui import QFileDialog
from files.model import LocalFileModel
try:
    from PyQt4.QtMaemo5 import QMaemo5ValueButton
except ImportError:
    class QMaemo5ValueButton(QPushButton):
        def setValueText(self, secondary):
            self.setText("%s\n%s" % (self.text(), secondary))
from errors import popup_exception, TransifexLoginFailed, TransifexInternalServerError

class ServerView(CustomWindow):
    def fileOpen(self):
        filename = QFileDialog.getOpenFileName(
            self, caption="Open translation file...",
            filter=QString("Gettext PO/POT (*.po *.pot)"),
            options=QFileDialog.DontUseSheet|QFileDialog.DontUseSheet)
        if filename:
            win = FileView(fp=LocalFileModel(filename), parent=self)
            win.show()
            
        
    def fileBrowseProjects(self):
        obj = ProjectsView(self, self.model)
        obj.show()

    def updateBookmarks(self):
        self.listviewBookmarks.model().reset()
        
    def openBookmark(self, index):
        remotefile = self.listviewBookmarks.model().data(index)
        obj = FileView(parent=self, fp=remotefile)
        obj.show()
    
    def login(self):
        # Get First name, Surname, E-mail
        d = config.data['servers'][self.model.hostname]
        
        if 'username' in d:
            username = d['username']
        else:
            username = None
            
        if 'password' in d:
            password = d['password']
            remember = True
        else:
            password = None
            remember = False
            
        while True: # Login loop
            try:
                if username and password and self.model.login(username, password):
                    d['username'] = username
                    if remember:
                        d['password'] = password
                    config.save()
                    if not 'profile' in d:
                        d['profile'] = self.model.get_user_info()
                        config.save()
                    return d
            except TransifexLoginFailed, e:
                popup_exception(e)
            except TransifexInternalServerError, e:
                popup_exception(e)
                return None
            username, password, remember, accepted = LoginDialog.getCredentials(
                server = self.model.hostname,
                username=username, password=password, remember=remember)
            if not accepted:
                return None

    def __init__(self, model):
        CustomWindow.__init__(self,title="",
            skip_central_widget=True,busy=False)
        self.model = model
        self.buttons = []
        
        d = self.login() # Show dialog if necessary

        menuFile = self.menuBar().addMenu(self.tr("&File"))
        if d:
            menuFile.addAction(
                IconCache.get("hildon/general_applications.png"),
                self.tr("&Browse projects..."), 
                self.fileBrowseProjects)
        menuFile.addAction(
            self.tr("&Open local file"),
            self.fileOpen)
            
        if not d:
#            self.close()
            return

        layout = QGridLayout(self)
        self.buttonProfile = QMaemo5ValueButton(
            QGravatar(u"%(email)s" % d['profile']),
            u"%(firstname)s %(surname)s" % d['profile'],
            parent = self)
        self.buttonProfile.setValueText(u"%(email)s" % d['profile'])
        layout.addWidget(self.buttonProfile, 0, 0)

             

        self.buttonBrowse = QMaemo5ValueButton(
            IconCache.get("hildon/general_applications.png"),
            self.tr("&Browse projects..."),
            parent=self)
        self.buttonBrowse.setValueText("at www.transifex.net")
        self.buttonBrowse.clicked.connect(self.fileBrowseProjects)
        
        #self.buttonBrowse.clicked.connect(self.updateBookmarks)
        layout.addWidget(self.buttonBrowse, 0, 1)


        m = BookmarkListModel(parent=self, server=self.model)
        self.listviewBookmarks = QListView(self)
        self.listviewBookmarks.setModel(m)
        self.listviewBookmarks.clicked.connect(self.openBookmark)
        layout.addWidget(self.listviewBookmarks , 1, 0, 1, 2)

        self.container = QWidget(self)
        self.container.setLayout(layout)
        
        self.model.locksInvalidated.connect(self.updateBookmarks) # AWESOME

        self.scrollarea = QScrollArea(self)
        self.scrollarea.setWidget(self.container)
        self.scrollarea.setWidgetResizable(True)
        self.setCentralWidget(self.scrollarea)
        
        
