# -*- coding: utf-8 -*-

from PyQt4.QtGui import QDialog, QLineEdit, QPushButton, QHBoxLayout

class SearchStringDialog(QDialog):
    @classmethod
    def getSearchString(self, title="Search string", default=None):
        d = SearchStringDialog(title=title)
        if d.exec_():
            return u"%s" % d.string.text()
        
    def __init__(self, title=None, parent=None):
        QDialog.__init__(self, parent)
        if title:
            self.setWindowTitle(title)
        self.setModal(True)
        self.resize(300,0)
        self.string = QLineEdit()
        self.string.setCompleter(None)
        self.button = QPushButton("Search")
        self.button.clicked.connect(self.accept)
        
        layout = QHBoxLayout()
        layout.addWidget(self.string)
        layout.addWidget(self.button)

        self.setLayout(layout)
