# -*- coding: utf-8 -*-

from common import QCustomWindow, QIconCache
from PyQt4.QtGui import QGridLayout, QLabel, QPushButton, QScrollArea,\
    QWidget, QAction
from PyQt4.QtCore import QSignalMapper
from PyQt4.Qt import Qt, pyqtSlot, SIGNAL, SLOT
from config import config
from projects.view import ProjectsView
from client import TransifexInstance
from views.server_add_dialog import ServerAddDialog

class Dashboard(QCustomWindow):
    def fileOpen(self):
        filename = QFileDialog.getOpenFileName(
            self, caption="Open translation file...",
            filter=QString("Gettext PO/POT (*.po *.pot)"),
            options=QFileDialog.DontUseSheet)
        if filename:
            config.latest_files_push(str(filename))
            obj = FileView(parent=self, filename=filename)
            obj.show()

    @pyqtSlot("QObject*")
    def serverBrowse(self, instance):
        obj = ProjectsView(self, instance)
        obj.show()


    def serverAdd(self):
        retval = ServerAddDialog.get()
        if retval:
            hostname, username, password = retval
            print "Adding server:",retval
            config.add_server(hostname, username, password)
            config.save()

    def __init__(self):
        QCustomWindow.__init__(self,skip_central_widget=True,busy=False)
        layout = QGridLayout(self)
        layout.addWidget(QLabel("PO-files"),0,0,1,0)
        y, x = 1, 0
        buttonFileOpen = QPushButton(QIconCache.get("document-open.svgz"), "Open file...", self)
        buttonFileOpen.clicked.connect(self.fileOpen)

        layout.addWidget(buttonFileOpen, y, x)
        print 'servers ==', config.data['servers']
        x = 1
        y = 0
        for filename in config.data['latest_files']: #ls("~/nano-2.2.4/po"):
            title = "%s\n%s"  % (filename, filename)
            button = QMaemo5ValueButton(QIconCache.get("text-x-po.svgz"), "PO-File", self)
            try:
                button.setValueText(filename)
            except AttributeError:
                pass
            layout.addWidget(button, y, x)
            x += 1
            if x == 2:
                y += 1
                x = 0
        if x >= 1:
            y += 1
        y += 1
        x = 0

        mapper = QSignalMapper(self)

        for hostname, credentals in config.data['servers'].iteritems():
            layout.addWidget(QLabel(hostname), y, 0, 1, 0)
            y += 1
            buttonEditProfile = QPushButton(
                QIconCache.get("document-open.svgz"), "Edit profile...", self)
            buttonBrowse = QPushButton(
                QIconCache.get("document-open.svgz"), "Browse...", self)
            buttonBrowse.clicked.connect(mapper.map)
            mapper.setMapping(
                buttonBrowse,
                TransifexInstance(hostname, "title=%s" % hostname, parent=self))
            layout.addWidget(buttonEditProfile, y, 0)
            layout.addWidget(buttonBrowse, y, 1)
            y += 1
        self.connect(
            mapper,
            SIGNAL("mapped(QObject*)"),
            self,
            SLOT("serverBrowse(QObject*)"))

        # Create objects
        scrollArea = QScrollArea(parent=self)
        scrollArea.setWidgetResizable(1)

        container = QWidget()
        container.setLayout(layout)

        scrollArea.setWidget(container)
        self.setCentralWidget(scrollArea)
        self.actionServersAdd = QAction("Add server...", self)
        self.actionServersAdd.triggered.connect(self.serverAdd)

        # File menu
        menuServers = self.menuBar().addMenu(self.tr("&Servers"))
        menuServers.addAction(self.actionServersAdd)