# -*- coding: utf-8 -*-
import shutil
import os

from PyQt4.QtCore import QModelIndex, QString, Qt, pyqtSignal, QSize, QTimer, QThread, \
    QAbstractItemModel
from PyQt4.QtGui import QSortFilterProxyModel, QTableView, QAbstractItemView, \
    QToolBar, QIcon, QPlainTextEdit, QHBoxLayout, QFileDialog, QMessageBox, \
    QWidget, QProgressDialog, QActionGroup
  
from common import QCustomWindow, QIconCache

class StringView(QCustomWindow):
    """
    String editor
    
    TODO: This file needs *a lot* restructuring
    """
    def updateModel(self):
        self.source_index = self.proxy_model.mapToSource(self.index)
        entry = self.model.data(self.source_index, Qt.UserRole)
        self.source_string.setPlainText(entry.msgid)
        self.translated_string.setPlainText(entry.msgstr)
        if entry.translated():
            self.actionSetTranslated.setChecked(True)
        elif entry.fuzzy():
            self.actionSetFuzzy.setChecked(True)
        else:
            self.actionSetUntranslated.setChecked(True)

    def __init__(self, proxy_string_list_model, index, parent=None):
        QCustomWindow.__init__(self, parent, title=u"String")
        self.index = index
        self.proxy_model = proxy_string_list_model
        self.model = self.proxy_model.sourceModel()

        self.source_string = QPlainTextEdit()
        self.source_string.setReadOnly(True)
        self.translated_string = QPlainTextEdit()
        self.translated_string.verticalScrollBar().valueChanged.connect(
            self.syncScrollBar)


        layout = QHBoxLayout(self.centralWidget())
        layout.addWidget(self.source_string)
        layout.addWidget(self.translated_string)

        toolbar = QToolBar(self)

        # Previous string button
        self.actionPrev = toolbar.addAction(
            QIconCache.get("go-previous.svgz"),
            self.tr("Previous string"),
            self.previous)

        # Next string button
        self.actionNext = toolbar.addAction(
            QIconCache.get("go-next.svgz"),
            self.tr("Next string"),
            self.next)
            
        toolbar.addSeparator()

        # Copy source button
        self.actionCopySource = toolbar.addAction(
            QIconCache.get("edit-copy.svgz"),
            self.tr("Copy source string"),
            self.copysource)

        # Auto translate button
        self.actionAutoTranslate = toolbar.addAction(
            QIconCache.get("accessories-dictionary.svgz"),
            self.tr("Auto-translate"),
            self.autotranslate)
            
        toolbar.addSeparator()

        # Set string to translated
        self.actionSetTranslated = toolbar.addAction(
            QIconCache.get("flag-green.svgz"),
            self.tr("Set string status to <i>translated</i>"),
            self.setTranslated)

        # Set string to fuzzy
        self.actionSetFuzzy = toolbar.addAction(
            QIconCache.get("flag-blue.svgz"),
            self.tr("Set string status to <i>fuzzy</i>"),
            self.setFuzzy)

        # Set string to untranslated
        self.actionSetUntranslated = toolbar.addAction(
            QIconCache.get("flag-red.svgz"),
            self.tr("Set string status to <i>untranslated</i>"),
            self.setUntranslated)
        
            
        # Status group
        group = QActionGroup(self)
        for i in self.actionSetTranslated, self.actionSetFuzzy, \
            self.actionSetUntranslated:
                i.setCheckable(True)
                group.addAction(i)
        
        self.updateModel()

        self.addToolBar(toolbar)

    def setTranslated(self):
        entry = self.model.data(self.source_index, Qt.UserRole)
        if entry.fuzzy():
            entry.flags.remove('fuzzy')
        if entry.translated():
            self.actionSetTranslated.setChecked(True)
        else:
            self.actionSetUntranslated.setChecked(True)
      
    def setFuzzy(self):
        entry = self.model.data(self.source_index, Qt.UserRole)
        if not entry.fuzzy():
            entry.flags.append('fuzzy')
        if entry.fuzzy() and entry.msgstr != "":
            self.actionSetFuzzy.setChecked(True)
        else:
            self.actionSetUntranslated.setChecked(True)

    def setUntranslated(self):
        # Are you sure?
        entry = self.model.data(self.source_index, Qt.UserRole)
        if entry.fuzzy():
            entry.flags.remove('fuzzy')
        entry.msgstr = u""
        self.translated_string.setPlainText(u"")
        self.actionSetUntranslated.setChecked(True)


    def next(self):
        # TODO: Better validation
        self.saveCurrentString()
        col, row, parent = self.index.column(), self.index.row(), \
            self.index.parent()
        row+=1
        if row>=self.proxy_model.rowCount(self.index):
            row = 0
        self.index = self.proxy_model.index(row,col,parent)
        self.updateModel()

    def previous(self):
        self.saveCurrentString()
        col, row, parent = self.index.column(), self.index.row(), \
            self.index.parent()
        row-=1
        if row < 0:
            row = self.proxy_model.rowCount(self.index)-1
        self.index = self.proxy_model.index(row,col,parent)
        self.updateModel()

    def syncScrollBar(self, val):
        """
        Synchronize source string text edit box with translation string
        """
        a = self.translated_string.verticalScrollBar()
        b = self.source_string.verticalScrollBar()
        b.setValue( -10 + val * 1.05 * b.maximum() / a.maximum())

    def autotranslate(self):
        self.model.autotranslate(self.source_index)
        entry = self.model.data(self.source_index, Qt.UserRole)
        self.translated_string.setPlainText(entry.msgstr)
        self.setFuzzy()

    def copysource(self):
        self.model.copysource(self.source_index)
        entry = self.model.data(self.source_index, Qt.UserRole)
        self.translated_string.setPlainText(entry.msgstr)
        self.setFuzzy()
        
    def saveCurrentString(self):
        self.model.data(self.source_index, Qt.UserRole).msgstr = \
            u"%s" % self.translated_string.toPlainText()


    def closeEvent(self, event):        
        self.saveCurrentString()
        event.accept()
