# -*- coding: utf-8 -*-

from PyQt4.QtCore import pyqtSignal, QObject
try:
    import simplejson as json
except ImportError:
    import json
import os
import time

class Config(QObject):
    bookmarksChanged = pyqtSignal()
    
    def __init__(self, filename="~/.config/transifex-client.json", autosave=True, parent=None):
        QObject.__init__(self, parent=parent)
        self.path = os.path.expanduser(filename)
        self.bookmarks = []
        try:
            raw = open(self.path, "ru").read()
            self.data = json.loads(raw)
        except (IOError, ValueError):
            self.data = {
                'latest_files' : [],
            }
        if not 'servers' in self.data:
            self.data['servers'] = {}
        #if not 'bookmarks' in self.data or True:
            #self.data['bookmarks'] = {
                #"http://www.transifex.net/projects/p/nano/c/default/raw/po/fr.po":
                    #1,
                #"http://www.transifex.net/projects/p/nano/c/default/raw/po/et.po":
                    #2,
                #"http://www.transifex.net/projects/p/nano/c/default/raw/po/fi.po":
                    #3,
            #}
        self.autosave = autosave


    def bookmarkFile(self, fp):
        if not fp in self.bookmarks:
            self.bookmarks.append(fp)
        else:
            print " :: %s is in %s already!" % (fp, self.bookmarks)

    #def latest_files_push(self, filename):
        #if filename in self.data['latest_files']:
            #self.data['latest_files'].remove(filename)
        #self.data['latest_files'].insert(0, filename)
        #if self.autosave:
            #self.save()

    def add_server(self, hostname, username=None, password=None):
        self.data['servers'][hostname] = {
            'username':username,
            'password':password }


    def save(self):
        fh = open(self.path, "wu")
        fh.write(json.dumps(self.data))
        fh.close()

config = Config()

