# -*- coding: utf-8 -*-

from common import QCustomWindow
from languages.model import LanguagesManager

class LanguageSelector(QListView):
    def selectionChanged(self, next, prev):
        self.model.activate(next.indexes())

    def __init__(self, parent=None, client=None):
        QListView.__init__(self, parent)
        self.model = LanguagesManager(parent, client)
        self.setModel(self.model)
        self.setProperty("FingerScrollable", True)        

class LanguageWindow(QCustomWindow):
    def __init__(self, parent=None, client=None, title="Available languages"):
        QCustomWindow.__init__(self, parent, title=title)
        self.setCentralWidget(LanguageSelector(parent, client))
