# -*- coding: utf-8 -*-

from PyQt4.QtCore import QAbstractListModel
from PyQt4.Qt import Qt
from common import QIconCache

class ComponentModel:
    def __init__(self, slug, title, client=None):
        self.slug = slug
        self.title = title
        self.client = client

class ComponentListModel(QAbstractListModel):
    def __init__(self, project=None, parent=None):
        QAbstractListModel.__init__(self, parent=parent)
        self.project = project
        self.objs = project.client.pullComponents(project.slug)

    def rowCount(self, parent):
        return len(self.objs)

    def data(self, index, role=Qt.UserRole):
        if not index.isValid():
            return None
        if index.row() < 0 or index.row() >= len(self.objs):
            return None
        if role == Qt.DecorationRole:
            return QIconCache.get("utilities-file-archiver.svgz")
        if role == Qt.DisplayRole:
            return self.objs[index.row()].title
            #return "%s (%s)" % (self.objs[index.row()].title,
                #self.objs[index.row()].slug)
        if role == Qt.UserRole:
            return self.objs[index.row()]
        return None
