#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import QApplication #, QMainWindow, QTableView, QGridLayout, \
    #QPushButton, QFileDialog, QIcon, QGroupBox, QVBoxLayout, QScrollArea, \
    #QWidget, QSizePolicy, QAction, QDialog, QLineEdit, QHBoxLayout, QLabel, \
    #QCheckBox, QComboBox, QFrame
#from PyQt4.QtCore import pyqtSlot, QString, Qt, QSignalMapper, SIGNAL, SLOT, \
    #QObject
import sys, os
#from gettextfile.view import FileView
#from common import QCustomWindow, QIconCache
#try:
#    from PyQt4.QtMaemo5 import QMaemo5ValueButton
#except:
#    QMaemo5ValueButton = QPushButton

def ls(directory, extension = "po"):
    return [os.path.join(directory, filename)
      for filename in os.listdir(os.path.expanduser(directory))
      if filename.lower().endswith(".%s" % extension)]

#from dashboard.view import Dashboard
from gettextfile.view import FileView
from common import QIconCache
from servers.model import ServerModel
import re
from files.model import RemoteFileModel
from servers.view import ServerView
from views.login import LoginDialog

from config import config
import random



def entry_point():
    for url in ["http://www.transifex.net/projects/p/nano/c/default/raw/po/fr.po",
    "http://www.transifex.net/projects/p/nano/c/default/raw/po/hu.po",
    "http://www.transifex.net/projects/p/nano/c/default/raw/po/it.po",
#    "http://www.transifex.net/projects/p/nano/c/default/raw/po/es.po",
    "http://www.transifex.net/projects/p/nano/c/default/raw/po/et.po",
    "http://www.transifex.net/projects/p/nano/c/default/raw/po/fi.po"]:
        fp = RemoteFileModel.getByURL(url)
        if fp:
            
            fp.last_access = random.randrange(0, 99)
            print "ADDED:", fp
            config.bookmarkFile(fp)

    app = QApplication(sys.argv + ['-title','Transifex-mobile'])
#    QIconCache.preload()
#    if "--dashboard" in sys.argv or "-d" in sys.argv:
#        win = Dashboard()
    if "-txn" in sys.argv:
        model = ServerModel("www.transifex.net", "Transifex.net")
        win = ServerView(model)
    else:
        try:
            url = sys.argv[1]
        except:
            print "No file path / URL specified!"
            return

        fp = RemoteFileModel.getByURL(url) or LocalFileModel(url)

        win = FileView(fp)
    win.show()
    sys.exit(app.exec_())

if __name__ == "__main__":
    entry_point()
