#!/usr/bin/python

from PyQt4 import QtGui, QtCore

class CircleProgress(QtGui.QProgressBar):
   def __init__(self, parent=None):
      QtGui.QProgressBar.__init__(self, parent)

      self.startAngle = 90*16
      self.pulsed=False
      self.anim = QtCore.QTimer()
      self.connect(self.anim, QtCore.SIGNAL("timeout()"), self.pulse)
      self.anim.setInterval(40)

      self.paint = QtGui.QPainter()

      self.font = QtGui.QFont('Candara', 12)
      self.font.setStyleStrategy(QtGui.QFont.PreferAntialias)

   def setPulse(self, b):
      if b:
         self.anim.start()
         self.pulsed=True
      else:
         self.anim.stop()
         self.pulsed=False

   def pulse(self):
      self.setValue(  (self.value()+4)%100 )

   def paintEvent(self, event):
      if self.maximum()<=0:
         return

      value = self.value()

      if value>self.maximum():
         value = self.maximum()
      if value<0:
         value = 0

      self.paint.begin(self)
      self.paint.setRenderHint( QtGui.QPainter.Antialiasing, True )

      m = self.contentsMargins()
      r = self.rect()
      rect = QtCore.QRect(r.x()+4+m.left(), r.y()+4+m.top(), r.width()-8-m.right(), r.height()-8-m.bottom())

      # draw progess bar
      color = QtGui.QColor("#2684DB")
      pen = QtGui.QPen(color)
      pen.setWidth( r.width()/6 )

      self.paint.setPen(pen)
      self.paint.setBrush(color)

      if self.pulsed:
         spanAngle = -90*16
         self.paint.drawArc(rect, -value*16*3.60, spanAngle)
      else:
         spanAngle = -(16*360*value-self.minimum())/(self.maximum()-self.minimum())
         self.paint.drawArc(rect, self.startAngle, spanAngle)

         if self.isTextVisible():
            fontSize = r.width()/6
            self.font.setPointSize(fontSize)
            self.paint.setFont(self.font)
            self.paint.drawText( r.width()/2-fontSize, r.height()/2+fontSize/1.5, "%d%%"%value )

      self.paint.end()
