﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
import ConfigParser
from urlparse import urlparse
from utils.htmlTools import htmlTools
from utils.DebugLog import DebugLog, DebugFile
from Extractor import Extractor
from model.RideModel import Ride

class TableParserMetro(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserMetro::__init__")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagHeurePassage = False
      self.tagHeurePassageB = False
      self.tagDestination = False
      self.tagDestinationMaybe = False
      self.tagDestinationB = False
      self.tagUnavailable = False
      self.station = False
      self.tagNoTrain = False
      self.destination = ''
      self.train = ''
      Extractor.Clear(self)
      self.stopParsing = False
      self.destinationDetailed = False

   def Feed(self, html):
      DebugLog("TableParserMetro::Feed")
      self.Clear()
      self.html = htmlTools.unescape(html.strip().decode('iso-8859-1'))
      if self.html.find('class="schmsg1"')!=-1:
          self.destinationDetailed = True
          
      self.feed(self.html)
      # if not self.destinationDetailed:
         # for ride in self.listRides:
            # ride.setDestination(self.arrivee)

   def handle_starttag(self, tag, attrs):
      if tag == 'div' and dict(attrs).has_key('class'):
         if dict(attrs)['class'] == 'subtitle':
            self.tagDestinationMaybe = True
            
         elif dict(attrs)['class'] == 'bg1' or dict(attrs)['class'] == 'bg3':
            self.tagDestination = True
            self.currentRide = Ride()
            self.tagHeurePassage = True
            
         elif dict(attrs)['class'] == 'error':
            self.tagUnavailable = True
            self.currentRide = Ride()

         elif dict(attrs)['class'] == 'schmsg1' or dict(attrs)['class'] == 'schmsg3':
            self.tagHeurePassage = True

      elif self.tagHeurePassage and tag == 'b':
         self.tagHeurePassageB = True
         
      elif self.tagDestination and tag == 'b':
         self.tagDestinationB = True

   def handle_data(self, data):
      if self.tagDestinationMaybe and not self.tagDestinationB:
         if data.strip()=="Direction":
            self.tagDestination = True
            self.currentRide = Ride()
         else:
            self.tagDestinationMaybe = False
         return

      if self.tagDestination or self.tagDestinationB:
         u = data.replace('>', '').strip()
         if not self.destinationDetailed:
            if self.tagDestinationMaybe:
               self.destination = u
            self.currentRide.setDestination(self.destination)
         else:
            self.currentRide.setDestination(u)

      if self.tagHeurePassageB:
         heure = data.strip()
         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.currentRide.setHeure(heure)

      if self.tagNoTrain:
         self.currentRide = Ride()
         self.currentRide.setTrain(u'Aucun train pour ce trajet')
         self.currentRide.setNoTrain(True)
         
      if self.tagUnavailable:
         self.currentRide = Ride()
         self.currentRide.setNoTrain(True)
         self.currentRide.setTrain(data.strip())

   def handle_endtag(self, tag):
      if self.tagUnavailable:
         self.listRides.append(self.currentRide)
         self.currentRide = None
         self.tagUnavailable = None
   
      if self.tagHeurePassageB and tag=='b':
         self.tagHeurePassage = False
         self.tagHeurePassageB = False
         self.listRides.append(self.currentRide)
         self.currentRide = None

      if self.tagDestinationMaybe and tag=='div':
         self.tagDestinationMaybe = False
         
      if self.tagDestination and tag=='div':
         self.tagDestination = False
         
      if self.tagDestinationB and tag=='b':
         self.tagDestinationB = False
         self.tagDestination = False

      if self.tagNoTrain:
         self.listRides.append(self.currentRide)
         self.currentRide = None
         self.tagNoTrain ^= (self.tagNoTrain and tag == 'div')

   def fillModel(self, imax):
      DebugLog("TableParserMetro::fillModel")
      self.AppendRidesToModel(imax)
      self.perturbation='perturb'

   def ParsePerturbation(self, str):
      DebugLog("TableParserMetro::ParsePerturbation")

      res = re.findall('<div class="trafic">(.+?)</div>', str, re.DOTALL)
      if res:
         for p in res:
            s = 'alt=["\']\s*Ligne %s["\'].+?(?:</b|<br)>(.+?)(?:<img.+?alt=["\']M)'%self.ligne
            r = re.search(s, p, re.DOTALL)
            
            if not r:
               s = 'alt=["\']\s*Ligne %s["\'].+?(?:</b|<br)>(.+?)(?:<b>Trafic normal)'%self.ligne
               r = re.search(s, p, re.DOTALL)
               if not r:
                  continue

            p=r.group(1)
            if not p:
               continue
         
            p=p.replace('\n',' ').replace('<br>', '\n')
            p=re.sub('\s+', ' ', p)
            p = re.sub('<.+?>', '', p).strip().replace('&#39;', "'")

            self.rideModel.AddPerturbation( unicode(p, 'utf-8') )

class ExtractorMetro(TableParserMetro):
   def __init__(self, ligne):
      DebugLog("ExtractorMetro::__init__")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      self.arrivee = ligne.arrivee
      lineTitle = ( ('M', self.ligne, 32), self.depart+ ' > '+ligne.arrivee)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://wap.ratp.fr/siv/schedule?service=next&reseau=metro&lineid=M%s&directionsens=%s&stationid=%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station )
      DebugLog(self.url)
      self.urlPerturb = 'http://www.ratp.fr/informer/trafic/trafic.php?cat=1'

      TableParserMetro.__init__(self)
