#!/usr/bin/python
# -*- coding: utf-8 -*-

from DebugLog import DebugLog
from ConfigParser import ConfigParser
import os, md5, time

class ConfFile:
   def __init__(self, fichier):
      self.config = ConfigParser()
      self.config.read(fichier)

   def get(self, section, key):
      try:
         return self.config.get(section, key)
      except:
         return ''

class RideConf:
   def __init__(self, ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction, sens):
      self.ligne = ligne
      self.tec = tec
      self.depart = depart
      self.codeDepart = codeDepart
      self.arrivee = arrivee
      self.codeArrivee = codeArrivee
      self.exploitant = exploitant
      self.direction = direction
      self.sens = sens

   def __str__(self):
      return u"ligne: %s\ntec: %s\ndepart: %s\ncodeDepart: %s\narrivee: %s\ncodeArrivee: %s\nexploitant: %s\ndirection: %s"%\
      (self.ligne, self.tec, self.depart, self.codeDepart, self.arrivee, self.codeArrivee, self.exploitant, self.direction)

class RidesConfig:
   def __init__(self, filename):
      DebugLog("RidesConfig::__init__")
      self.rides=dict()
      self.hasChanged = False
      self.filename = filename

   def AddRide(self, ride, id=''):
      DebugLog("RidesConfig::AddRide(%s)"%id)
      self.hasChanged = True
      if not id or id in self.rides.keys():
         id = 'Ride%d'%(self.LastId()+1)
         DebugLog("  RidesConfig::AddRide(create id%s)"%id)
      self.rides[id] = ride
      ride.id = id

   def RemoveRide(self, id):
      DebugLog("RidesConfig::RemoveRide(%s)"%id)
      del self.rides[id]
      DebugLog(str([k for k in sorted(self.rides.keys())]))
      self.hasChanged = True

   def GetRides(self):
      return [self.rides[k] for k in sorted(self.rides.keys())]

   def LastId(self):
      if not len(self.rides):
         return 0
      else:
         strid = sorted(self.rides.keys(), reverse=True)[0]
         return int(strid[4:])

   def ReadRides(self):
      DebugLog("RidesConfig::ReadRides")
      self.rides=dict()
      t = ConfFile(self.filename)

      for section in t.config.sections():
         ligne = t.get(section, 'ligne')
         tec = t.get(section, 'tec')
         depart = t.get(section, 'depart').decode('utf-8')
         arrivee = t.get(section, 'arrivee').decode('utf-8')
         codeDepart = t.get(section, 'codeDepart')
         codeArrivee = t.get(section, 'codeArrivee')
         exploitant = t.get(section, 'exploitant')
         direction = t.get(section, 'direction')
         sens = 0
         try:
            sens = int(t.get(section, 'sens'))
         except:
            sens = 0

         if codeDepart  and tec and depart:
            l = RideConf(ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction, sens)
            self.AddRide(l, section)

      self.hasChanged = False

   def Write(self):
      self.WriteRides()
      self.hasChanged = False

   def WriteRides(self, filename=''):
      if not filename:
         filename = self.filename

      f = open(filename, 'w')
      #t = ConfigParser()
      iride=1

      DebugLog("nb rides=%d"%len(self.rides.values()))

      for k in sorted(self.rides.keys()):
         ride = self.rides[k]
         key="Ride%d"%iride
         f.write('[%s]\n'%key.strip())
         f.write('tec=%s\n'%ride.tec.strip())
         f.write('Ligne=%s\n'%ride.ligne.strip())
         f.write('depart=%s\n'%ride.depart.encode('utf-8').strip())
         f.write('arrivee=%s\n'%ride.arrivee.encode('utf-8').strip())
         f.write('codeDepart=%s\n'%ride.codeDepart.strip())
         f.write('codeArrivee=%s\n'%ride.codeArrivee.strip())
         f.write('exploitant=%s\n'%ride.exploitant.strip())
         f.write('sens=%s\n'%str(ride.sens))
         if ride.direction:
            f.write('direction=%s\n'%ride.direction.strip())

         f.write('\n')
#         t.add_section(key)
#         t.set(key, 'TEC', ride.tec)
#         t.set(key, 'Ligne', ride.ligne)
#         t.set(key, 'depart', ride.depart.encode('utf-8'))
#         t.set(key, 'arrivee', ride.arrivee.encode('utf-8'))
#         t.set(key, 'codeDepart', ride.codeDepart)
#         t.set(key, 'codeArrivee', ride.codeArrivee)
#         t.set(key, 'exploitant', ride.exploitant)
#         if ride.direction:
#            t.set(key, 'direction', ride.direction)
         iride += 1

#      t.write(f)
      f.close()


class TrainTrainConf:
   def __init__(self):
      confDir = os.path.join(os.path.expanduser('~'),".traintrain")
      if not os.path.exists(confDir):
         os.makedirs(confDir)
      self.conf = os.path.join(confDir, "traintrain.conf")
      self.ReadConfig()

   def ReadConfig(self):
      self.nb = 2
      self.refreshrate = '1 min'
      if os.path.exists(self.conf):
         t = ConfigParser()
         t.read(self.conf)
         try:
            self.nb = int(t.get('trajets', 'nbtrains'))
         except:
            pass
         try:
            self.refreshrate = t.get('trajets', 'refreshrate')
         except:
            pass
         try:
            self.ttid = t.get('trajets', 'ttid')
         except:
            m = md5.new()
            m.update( str(time.time()) )
            self.ttid = m.hexdigest()
            self.WriteConfig()
      else:
         self.WriteConfig()

   def SetNbTrains(self, nb):
      self.nb = nb

   def SetRefreshRate(self, rr):
      self.refreshrate = rr

   def WriteConfig(self):
      f = open(self.conf, 'w')
      t = ConfigParser()

      t.add_section('trajets')
      t.set('trajets', 'nbtrains', self.nb)
      t.set('trajets', 'refreshrate', self.refreshrate)
      t.set('trajets', 'ttid', self.ttid)
      t.write(f)

   def nbTrains(self):
      return self.nb

   def refreshRate(self):
      return self.refreshrate

   def refreshRateSec(self):
      r=self.refreshrate
      if r=='15 s':
         return 15
      if r=='30 s':
         return 30
      if r=='1 min':
         return 60
      if r=='5 min':
         return 300

