#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, re, gzip, StringIO, zlib
from urlparse import urlparse
from PyQt4 import QtCore
from PyQt4.QtNetwork import QNetworkRequest, QNetworkAccessManager, QNetworkProxy, QNetworkReply
import HTMLParser
from utils.DebugLog import DebugLog, DebugFile
from model.RideModel import RideModel, Ride

class Extractor(QtCore.QObject):
   def __init__(self, id):
      DebugLog("Extractor::__init__")
      QtCore.QObject.__init__(self)

      self.url = ''
      self.report = 'http://gerald.fauvelle.free.fr/traintrain/report.php?ttid=%s&error=%s&url=%s'
      
      self.userAgent = 'Firefox/3.5 Maemo Browser 1.7.4.8 RX-51 N900'
      self.urlPerturb = ''
      self.rideModel = RideModel(id)
      self.parser = None
      self.treestore = None
      self.max = 0
      self.fetching = False
      self.id = id
      self.cpt=0

      self.online = False
      self.manager = None
      self.currentRide = None
      self.parsePerturbation =  False
      self.parseDetails = False

   def Clear(self):
      self.listRides = []
      self.perturbation = ""
      self.error = ""
      self.currentRide = None

   def SetOnline(self, b):
      self.online = b

   def InitNetwork(self):
      self.manager2 = QNetworkAccessManager()
      self.manager = QNetworkAccessManager()
      self.connect(self.manager, QtCore.SIGNAL("finished(QNetworkReply *)"), self.readResponse )

      proxy = os.environ.get('PROXY')
      if proxy:
         o = urlparse(proxy)
         netlocL = o.netloc.find(':')
         host = o.netloc[:netlocL]
         self.proxy = QNetworkProxy(QNetworkProxy.HttpProxy, host, o.port)
         self.manager.setProxy(self.proxy)
         self.manager2.setProxy(self.proxy)

   def SetOnline(self, b):
      self.online = b
      if self.online:
         self.InitNetwork()

   def FetchDatas(self, model, max):
      DebugLog("Extractor::FetchDatas %s"%self.id)
      if self.fetching:
         DebugLog("  Already fetching")
         return

      self.fetching = True
      self.max = max
      self.model = model
      self.rideModel.Clear()

      if self.online and self.manager:
         request = QNetworkRequest( QtCore.QUrl(self.url) )
         request.setRawHeader("User-Agent", self.userAgent)
         request.setRawHeader( "Accept-Encoding", "gzip, deflate" )
         reply = self.manager.get(request)
         self.connect(reply, QtCore.SIGNAL("downloadProgress(qint64, qint64)"), self.updateBar)

      else:
         data = open('HSL-EM.htm', 'r').read()
         #data = open('LaTourMaubourg8A.htm').read()

         self.Parse(data)

   def updateBar(self, read,total):
      self.rideModel.SetProgress(read, total)

   def readResponse(self, reply):
      DebugLog("Extractor::readResponse %s"%self.id)
      error = reply.error()

      html = str(reply.readAll())
      DebugLog("readData %d"%len(html))
         
      # handle compressed datas
      if reply.hasRawHeader("Content-Encoding"):
         encoding = reply.rawHeader("Content-Encoding")
         DebugLog("encoding:%s"%encoding)
         if encoding in ('gzip', 'x-gzip', 'deflate'):
            if encoding == 'deflate':
               html = StringIO.StringIO(zlib.decompress(html))
            else:
               try:  # Try except, it seems ratp.mobi returns gzip Content-Encoding, but not gzipped at all :-(
                  html = gzip.GzipFile('', 'rb', 9, StringIO.StringIO(html)).read()
               except Exception, e:
                  DebugLog(str(e))
            DebugLog("readData decoded %d"%len(html))

      # test d'erreur, en général, pas de connection internet
      if error != QNetworkReply.NoError:
         #DebugLog(html)
         self.rideModel.SetInfo('ERROR', u"Erreur %d, vérifiez votre connection Internet"%error)

      #DebugFile(html)

      if self.parsePerturbation:
         self.ParsePerturbation(html)
         self.parsePerturbation = False

      elif self.parseDetails:
         self.ParseDetails(html, reply)

      else:
         self.Parse(html)

      if self.extracted:
         self.emit(QtCore.SIGNAL('extracted'), self.rideModel)
         self.fetching = False

   def Parse(self, str):
      DebugLog("Extractor::Parse %s"%self.id)

      try:
         self.Feed( str )
      except HTMLParser.HTMLParseError, e:
         print e

      self.extracted = True

      if self.online:
         if self.perturbation:
            DebugLog("perturbation : %s"%self.urlPerturb)
            self.parsePerturbation =  True
            request = QNetworkRequest( QtCore.QUrl( self.urlPerturb ) )
            request.setRawHeader("User-Agent", self.userAgent)
            self.manager.get(request)

         if self.parseDetails:
            self.extracted = False
            self.cpt=0
            for ride in self.listRides:
               if ride.detailsUrl:
                  #DebugLog("details : %s"%self.urlPerturb)
                  request = QNetworkRequest( QtCore.QUrl(ride.detailsUrl) )
                  request.setRawHeader("User-Agent", self.userAgent)
                  self.manager.get(request)

      if self.extracted:
         self.fillModel(self.max)
                  
      if self.error:
         self.rideModel.SetInfo('ERROR', self.error)

   def ParsePerturbation(self, str):
      pass

   def ParseDetails(self, html, reply):
      DebugLog("Extractor::ParseDetails")
      self.cpt += 1
      for ride in self.listRides:
         if ride.detailsUrl==reply.url().toString():
            self.MatchTrains(html, ride)
            break

      if self.cpt>=len(self.listRides):
         self.parseDetails = False
         self.extracted = True

      if self.extracted:
         self.fillModel(self.max)
         
   def AppendRidesToModel(self, imax):
      DebugLog("Extractor::AppendRidesToModel %s"%self.id)
      DebugLog("  len(self.listRides)=%d"%len(self.listRides))
      error = ''
      if len(self.listRides)==0:
         DebugFile(self.html, 'html_%s.html'%self.id)
         error = self.html
         
      requestReport = QNetworkRequest( QtCore.QUrl(self.report%(self.model.ttConf.ttid, error, self.url)) )
      requestReport.setRawHeader("User-Agent", self.userAgent)
      reply = self.manager2.get(requestReport)
      
      cpt = 0
      for ride in self.listRides:
         if not ride.match:
            continue
         self.rideModel.addRide(ride)
         cpt += 1
         if imax>0 and cpt>=imax:
            break
