#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
from urlparse import urlparse
from utils.htmlTools import htmlTools
from utils.DebugLog import DebugLog
from Extractor import Extractor
from model.RideModel import Ride

class TableParserRERratp(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserRERratpMobi::Init")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagHeureMission = False
      self.tagDestination = False
      self.tagTrainA = False
      self.tagHeurePassageB = False
      self.tagError = False
      Extractor.Clear(self)
      self.stopParsing = False

   def Feed(self,  html):
      DebugLog("TableParserRERratp::Feed %s"%self.id)
      self.Clear()
      self.html = htmlTools.unescape(html.strip().decode('iso-8859-1'))
      self.feed(self.html)

   def handle_starttag(self, tag, attrs):
      if tag=='div':
         if dict(attrs).has_key('class'):
            if dict(attrs)['class'] == 'bg1' or dict(attrs)['class'] == 'bg3':
               DebugLog("  self.tagDestination = True")
               self.tagDestination = True
               self.currentRide = Ride()

            elif dict(attrs)['class'] == 'schmsg1' or dict(attrs)['class'] == 'schmsg3':
               self.tagHeureMission = True
            
            elif dict(attrs)['class'] == 'error':
               DebugLog("  Error found!")
               self.tagError = True
               
         elif dict(attrs).has_key('id') and dict(attrs)['id']=='message':
            DebugLog("  Error found!")
            self.tagError = True

      elif self.tagHeureMission and tag == 'b':
         self.tagHeurePassageB = True
         
      elif self.tagHeureMission and tag == 'a':
         self.tagTrainA = True

   def handle_data(self, data):
      if self.tagDestination:
         u = data.replace('>', '').strip()
         self.currentRide.setDestination(u)
         
      if self.tagTrainA:
         self.currentRide.setTrain(data.strip())

      if self.tagHeurePassageB:
         heure = data.strip()
         voie=''
         res = re.search("(.+?)\s[^v]*V.+?(\d+)", heure)
         if res:
            heure = res.group(1).strip()
            voie = res.group(2).strip()

         self.currentRide.setVoie(voie)

         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.currentRide.setHeure(heure)
         
      if self.tagError:
         if not self.currentRide:
            self.currentRide = Ride()
         self.currentRide.setError(self.currentRide.error+data.strip())
         DebugLog(data.strip())

   def handle_endtag(self, tag):
      if self.tagHeurePassageB and tag=='b':
         self.tagHeurePassage = False
         self.tagHeurePassageB = False
         self.listRides.append(self.currentRide)
         self.currentRide = None
   
      if self.tagError:
         self.listRides.append(self.currentRide)
         self.currentRide = None
      
      self.tagDestination ^= (self.tagDestination and tag=='div')
      self.tagTrainA ^= (self.tagTrainA and tag=='a')
      self.tagHeureMission ^= (self.tagHeureMission and tag=='div')
      self.tagError ^= (self.tagError and tag=='div')

   def fillModel(self, imax):
      DebugLog("TableParserRERratp::fillModel(%s)"%self.id)
      if self.sens!='A' and self.sens!='R':
         self.rideModel.SetInfo('ERROR', 'Sens du trajet indfini: "%s"'%self.sens)
      
      self.AppendRidesToModel(imax)
      return self.perturbation, self.error

   def ParsePerturbation(self, str):
      DebugLog("TableParserTransilien::ParsePerturbation")

      res = re.findall('<div class="trafic">(.+?)</div>', str, re.DOTALL)
      if res:
         for perturbation in res:
            p = re.sub('<.+?>', '',perturbation).strip().replace('&#39;', "'")
            if p.find('Trafic normal')==-1:
               self.rideModel.AddPerturbation( unicode(p, 'utf-8') )

class ExtractorRERratp(TableParserRERratp):
   def __init__(self, ligne):
      DebugLog("ExtractorRERratpMobi::Init")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('R', self.ligne, 32), self.depart)
      self.rideModel.setIconTitle( lineTitle )

      #urlMobi = 'http://www.ratp.fr/horaires/fr/ratp/rer/prochains_passages/R%s/%s/%s'
      urlMobi = 'http://wap.ratp.fr/siv/schedule?service=next&reseau=rer&lineid=R%s&directionsens=%s&stationid=%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station)
      DebugLog(self.url)

      TableParserRERratp.__init__(self)
