#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
from Extractor import Extractor
from utils.DebugLog import DebugLog

class TableParserRERratp(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserRERratp::Init")

      HTMLParser.HTMLParser.__init__(self)

   def Clear(self):
      self.tagHeurePassage = False
      self.tagDestination = False
      self.tagTrain = False
      self.tagTrainA = False
      self.tagError = False
      self.tagErrorLi = False
      Extractor.Clear(self)

   def Feed(self,  html):
      self.Clear()
      res = re.search('(<fieldset class="rer">(.+)</fieldset>)', html, re.DOTALL)
      if res:
         html = res.group(1)
      self.feed(html)

   def handle_starttag(self, tag, attrs):
      if tag=='td':
         if dict(attrs).has_key('class'):
            if dict(attrs)['class'] == 'name':
               self.tagTrain = True

            elif dict(attrs)['class'] == 'terminus':
               self.tagDestination = True

            elif dict(attrs)['class'] == 'passing_time':
               self.tagHeurePassage = True

      elif self.tagTrain and tag == 'a':
         self.tagTrainA = True

      elif tag=='ul' and dict(attrs).has_key('class') and dict(attrs)['class']=='error_list':
         self.tagError = True

      elif self.tagError and tag=='li':
         self.tagErrorLi = True

   def handle_data(self, data):
      if self.tagDestination:
         self.liste_destination.append(data.strip())

      if self.tagTrainA:
         self.liste_train.append(data.strip())

      if self.tagHeurePassage:
         heure = data.strip()
         voie=''
         res = re.search("(.+?)\s[^v]*V.+?(\d+)", heure)
         if res:
            heure = res.group(1).strip()
            voie = res.group(2).strip()

         self.liste_voie.append(voie)

         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.liste_horaire.append(heure)

      if self.tagErrorLi:
         self.error += data.strip()

   def handle_endtag(self, tag):
      self.tagDestination ^= (self.tagDestination and tag == 'td')
      self.tagTrain ^= (self.tagTrain and tag == 'td')
      self.tagTrainA ^= (self.tagTrainA and tag == 'a')
      self.tagHeurePassage ^= (self.tagHeurePassage and tag == 'td')
      if self.tagErrorLi and tag=='li':
         self.tagErrorLi = False
         self.tagError = False

   def fillModel(self, imax):
      DebugLog("TableParserRERratp::fillModel(%s)"%self.id)
      self.AppendRidesToModel(imax)
      return self.perturbation, self.error

class ExtractorRERratp(TableParserRERratp):
   def __init__(self, ligne):
      DebugLog("ExtractorRERratp::Init")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = self.depart.replace(" ", "+")
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('R', self.ligne, 32), self.depart)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://www.ratp.fr/horaires/fr/ratp/rer/prochains_passages/R%s/%s/%s'
      self.url = urlMobi%(self.ligne, self.station, self.sens)
      DebugLog(self.url)

      TableParserRERratp.__init__(self)
