#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
import ConfigParser
from utils.htmlTools import htmlTools
from Extractor import Extractor
from utils.DebugLog import DebugLog, DebugFile

class TableParserMetro(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserMetro::Init")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagHeurePassage = False
      self.tagHeurePassageB = False
      self.tagDestination = False
      self.station = False
      self.noTrain = False
      self.train = ''
      Extractor.Clear(self)
      self.stopParsing = False

   def Feed(self, html):
      self.Clear()
      html = htmlTools.unescape(html.strip())
      self.feed(html)

   def handle_starttag(self, tag, attrs):
      if (tag == 'div' and dict(attrs).has_key('class') ):
         if dict(attrs)['class'] == 'bg1' or dict(attrs)['class'] == 'bg3':
            self.tagDestination = True

         elif dict(attrs)['class'] == 'schmsg1' or dict(attrs)['class'] == 'schmsg3':
            self.tagHeurePassage = True

      elif self.tagHeurePassage and tag == 'b':
         self.tagHeurePassageB = True

   def handle_data(self, data):
      if self.tagDestination:
         u = data.replace('>', '').strip()
         self.liste_train.append('')
         self.liste_destination.append(u)
         self.liste_voie.append('')

      if self.tagHeurePassageB:
         heure = data.strip()
         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.liste_horaire.append(heure)

      if self.noTrain:
         self.liste_voie.append('')
         self.liste_destination.append('')
         self.liste_horaire.append('')
         self.liste_train.append('Aucun train pour ce trajet')

   def handle_endtag(self, tag):
      if self.tagHeurePassageB and tag=='b':
         self.tagHeurePassage = False
         self.tagHeurePassageB = False

      if self.tagDestination and tag=='div':
         self.tagDestination = False

      self.noTrain ^= (self.noTrain and tag == 'div')

   def fillModel(self, imax):
      DebugLog("TableParserTransilien::fillModel")
      self.AppendRidesToModel(imax)
      return self.perturbation, self.error

class ExtractorMetro(TableParserMetro):
   def __init__(self, ligne):
      DebugLog("ExtractorMetro::Init")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('M', self.ligne, 32), self.depart)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://wap.ratp.fr/siv/schedule?service=next&reseau=metro&lineid=M%s&directionsens=%s&stationid=%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station )
      DebugLog(self.url)

      TableParserMetro.__init__(self)
