#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
import ConfigParser
from Extractor import Extractor
from utils.DebugLog import DebugLog, DebugFile

class TableParserMetro(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserMetro::Init")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagTableHoraires = False
      self.tagHeurePassage = False
      self.tagDestination = False
      self.tagError = False
      self.tagErrorLi = False
      self.station = False
      self.noTrain = False
      self.train = ''
      Extractor.Clear(self)
      self.stopParsing = False
      self.next = 'Destination'

   def Feed(self,  html):
      self.Clear()
      res = re.search('(<div id="prochains_passages">(.+)</div>).*?<div id="correspondances">', html, re.DOTALL)
      if res:
         html = res.group(1)
      DebugFile(html)
      self.feed(html)

   def handle_starttag(self, tag, attrs):
      if (tag == 'div' and dict(attrs).has_key('id') ):
         if (dict(attrs)['id'] == 'prochains_passages'):
            self.tagTableHoraires = True
         elif self.tagTableHoraires:
            self.tagTableHoraires = False

      elif self.tagTableHoraires and tag == 'td':
         if self.next=='Heure':
            self.tagHeurePassage = True
         else:
            self.tagDestination = True
      
      elif tag=='ul':
         if dict(attrs).has_key('class') and dict(attrs)['class']=='error_list':
            self.tagError = True
         
      elif self.tagError and tag=='li':
         self.tagErrorLi = True

   def handle_data(self, data):
      if self.station:
         self.liste_horaire.append( data.strip())

      if self.tagDestination:
         self.liste_train.append('')
         u=unicode(data.strip(), 'utf-8')
         self.liste_destination.append(u)
         self.liste_voie.append( '')

      if not self.tagTableHoraires:
         return

      if self.tagHeurePassage:
         heure = data.strip()
         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.liste_horaire.append(heure)

      if self.noTrain:
         self.liste_voie.append('')
         self.liste_destination.append('')
         self.liste_horaire.append('')
         self.liste_train.append('Aucun train pour ce trajet')

      if self.tagErrorLi:
         self.error += data.strip()
         
   def handle_endtag(self, tag):
      if self.tagHeurePassage and tag=='td':
         self.tagHeurePassage = False
         self.next = 'Destination'

      if self.tagDestination and tag=='td':
         self.tagDestination = False
         self.next = 'Heure'

      self.noTrain ^= (self.noTrain and tag == 'div')
      self.station ^= (self.station and tag == 'span')
      
      if self.tagErrorLi and tag=='li':
         self.tagErrorLi = False
         self.tagError = False

   def fillModel(self, imax):
      DebugLog("TableParserTransilien::fillModel")
      self.AppendRidesToModel(imax)
      return self.perturbation, self.error

class ExtractorMetro(TableParserMetro):
   def __init__(self, ligne):
      DebugLog("ExtractorMetro::Init")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('M', self.ligne, 32), self.depart)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://www.ratp.fr/horaires/fr/ratp/metro/prochains_passages/PP/%s/%s/%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station )
      DebugLog(self.url)

      TableParserMetro.__init__(self)
