#!/usr/bin/env python
# -*- coding: utf-8 -*-

from DebugLog import DebugLog
from PyQt4 import QtCore
id=0

class Ride:
   def __init__(self, train, heure, destination, voie):
      self.train = train
      self.heure = heure
      self.destination = destination
      self.voie = voie

class RideModel(QtCore.QObject):
   def __init__(self, id):
      DebugLog("RideModel::__init__")
      QtCore.QObject.__init__(self)

      self.rides = []
      self.perturbations = []
      self.id = id
      self.read=0
      self.total=0
      self.progress=0.0

   def Clear(self):
      DebugLog("RideModel::Clear")
      self.rides = []
      self.perturbations = []

   def getIcon(self):
      return self.icon

   def getTitle(self):
      return self.title

   def getRides(self):
      return self.rides

   def getPerturbations(self):
      return self.perturbations

   def AddPerturbation(self, perturbation):
      self.perturbations.append(perturbation)

   def setIconTitle(self, icontitle):
      self.icon, self.title = icontitle

   def addRide(self, ride):
      self.rides.append(ride)

   def SetInfo(self, stype, text):
      self.emit(QtCore.SIGNAL('info'), stype, text)

   def SetProgress(self, read, total):
      self.read = read
      self.total = total
      if total>0:
         self.progress=float(100.0*read)/float(total)
      self.emit(QtCore.SIGNAL('progress'))
