#!/usr/bin/python
# -*- coding: utf-8 -*-

import HTMLParser
from Extractor import Extractor
from DebugLog import DebugLog
from RideModel import RideModel, Ride

class TableParserTransilien(Extractor, HTMLParser.HTMLParser):
   def __init__(self, a, b):
      DebugLog("TableParserTransilien::__init__")

      HTMLParser.HTMLParser.__init__(self)

      self.id = a+" -> "+b
      self.Clear()

   def Clear(self):
      self.tagTableHoraires = False
      self.tagHeurePassage = False
      self.tagDestination = False
      self.tagCodeMission = False
      self.tagHeurePassageB = False
      self.noTrain = False
      self.tagVoie = False
      Extractor.Clear(self)

   def Feed(self, html):
      self.Clear()
      self.feed(html)

   def handle_starttag(self, tag, attrs):
      if (tag == 'table' and dict(attrs).has_key('id') and (dict(attrs)['id'] == 'listeTrain')):
         self.tagTableHoraires = True

      elif self.tagTableHoraires and tag == 'div':
         try:
            self.tagCodeMission = ( dict(attrs)['id'] == 'Train')
            self.tagHeurePassage = ( dict(attrs)['id'] == 'heure')
            self.tagVoie = ( dict(attrs)['id'] == 'voie')
            self.tagDestination = ( dict(attrs)['id'] == 'destination')

         except KeyError:
            if dict(attrs).has_key('id'):
               raise
            else:
               pass

      elif not self.tagTableHoraires and tag == 'div':
         if dict(attrs).has_key('id') and dict(attrs)['id'] == 'noTrain':
            self.noTrain = True
      elif tag == 'a' and dict(attrs).has_key('class') and (dict(attrs)['class'] == 'lienIcv'):
         self.perturbation = dict(attrs)['href']
      else:
         self.tagHeurePassageB = (tag == 'b' and self.tagHeurePassage)

   def handle_data(self, data):
      # execute pour chaque contenu de balise
      if self.tagCodeMission:
         self.liste_train.append(data.strip())

      if self.tagHeurePassageB:
         self.liste_horaire.append(data.strip())

      if self.tagDestination:
         data = data.strip().strip('\r').strip('\n')
         if data:
            self.liste_destination.append(data.strip())

      if self.tagVoie:
         data = data.strip().strip('\r').strip('\n')
         if data:
            self.liste_voie.append(data.strip())

      if self.noTrain:
         self.liste_voie.append('')
         self.liste_destination.append('')
         self.liste_horaire.append('')
         self.liste_train.append('Aucun train pour ce trajet')
         self.noTrain = False

   def handle_endtag(self, tag):
      # Execute à chaque balise fermante
      self.tagCodeMission ^= (self.tagCodeMission and tag == 'div')
      self.tagHeurePassageB ^= (self.tagHeurePassageB and tag == 'b')
      self.tagDestination ^= (self.tagDestination and tag == 'div')
      self.tagVoie ^= (self.tagVoie and tag == 'div')

   def fillModel(self, imax):
      DebugLog("TableParserTransilien::fillModel(%s)"%self.id)

      self.AppendRidesToModel(imax)
      return self.perturbation, self.error

class ExtractorTransilien(TableParserTransilien):
   def __init__(self, ligne):
      DebugLog("ExtractorTransilien::Init")

      Extractor.__init__(self, ligne.id)

      self.gare_depart = ligne.codeDepart
      self.gare_arrivee = ligne.codeArrivee
      self.ligne = ligne.ligne
      lineTitle = ( ('R', self.ligne, 32), ligne.depart) #+' > '+arriveeName)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://transilien.mobi/TempReelListe.do?depart.code=%s&arrivee.code=%s'
      self.url = urlMobi%(self.gare_depart, self.gare_arrivee)
      DebugLog(self.url)

      TableParserTransilien.__init__(self, self.gare_depart, self.gare_arrivee)

